/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.http.support.okhttp;

import com.foxinmy.weixin4j.http.AbstractHttpClient;
import com.foxinmy.weixin4j.http.HttpClientException;
import com.foxinmy.weixin4j.http.HttpHeaders;
import com.foxinmy.weixin4j.http.HttpRequest;
import com.foxinmy.weixin4j.http.HttpResponse;
import com.foxinmy.weixin4j.http.entity.HttpEntity;
import com.foxinmy.weixin4j.http.support.okhttp.OkHttpResponse3;
import com.foxinmy.weixin4j.util.StringUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;

public class OkHttpClient3
extends AbstractHttpClient {
    private final OkHttpClient okClient;

    public OkHttpClient3(OkHttpClient okClient) {
        this.okClient = okClient;
    }

    @Override
    public HttpResponse execute(HttpRequest request) throws HttpClientException {
        HttpResponse response = null;
        try {
            Request okRequest = this.createRequest(request);
            Response okResponse = this.okClient.newCall(okRequest).execute();
            response = new OkHttpResponse3(okResponse, okResponse.body().bytes());
            this.handleResponse(response);
        }
        catch (IOException e) {
            throw new HttpClientException("I/O error on " + request.getMethod().name() + " request for \"" + request.getURI().toString() + "\":" + e.getMessage(), e);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        return response;
    }

    protected Request createRequest(HttpRequest request) throws HttpClientException {
        Request.Builder requestBuilder = this.createBuilder(request);
        this.resolveHeaders(requestBuilder, request);
        this.resolveContent(requestBuilder, request);
        return requestBuilder.build();
    }

    protected Request.Builder createBuilder(HttpRequest request) throws HttpClientException {
        Request.Builder requestBuilder = new Request.Builder();
        try {
            requestBuilder.url(request.getURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new HttpClientException("format URI error", e);
        }
        return requestBuilder;
    }

    protected void resolveHeaders(Request.Builder builder, HttpRequest request) {
        HttpHeaders headers = request.getHeaders();
        if (headers == null) {
            headers = new HttpHeaders();
        }
        if (!headers.containsKey("Accept")) {
            headers.set("Accept", "*/*");
        }
        if (!headers.containsKey("User-Agent")) {
            headers.set("User-Agent", "square/okhttp3");
        }
        for (Map.Entry<String, List<String>> header : headers.entrySet()) {
            if ("Cookie".equalsIgnoreCase(header.getKey())) {
                builder.header(header.getKey(), StringUtil.join((Iterable)header.getValue(), ';'));
                continue;
            }
            for (String headerValue : header.getValue()) {
                builder.header(header.getKey(), headerValue != null ? headerValue : "");
            }
        }
    }

    protected void resolveContent(Request.Builder builder, HttpRequest request) throws HttpClientException {
        final HttpEntity entity = request.getEntity();
        RequestBody body = null;
        if (entity != null) {
            body = new RequestBody(){

                public long contentLength() throws IOException {
                    return entity.getContentLength();
                }

                public void writeTo(BufferedSink sink) throws IOException {
                    entity.writeTo(sink.outputStream());
                }

                public MediaType contentType() {
                    return MediaType.parse((String)entity.getContentType().toString());
                }
            };
        }
        builder.method(request.getMethod().name(), body);
    }
}

