/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.http.support.netty;

import com.foxinmy.weixin4j.http.HttpClient;
import com.foxinmy.weixin4j.http.HttpParams;
import com.foxinmy.weixin4j.http.factory.HttpClientFactory;
import com.foxinmy.weixin4j.http.support.netty.Netty4HttpClient;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class Netty4HttpClientFactory
extends HttpClientFactory {
    private volatile Bootstrap bootstrap;
    private EventLoopGroup eventLoopGroup;
    private Map<ChannelOption<?>, ?> options;
    private HttpParams params;

    public Netty4HttpClientFactory() {
        this((EventLoopGroup)new NioEventLoopGroup(Runtime.getRuntime().availableProcessors() * 4));
    }

    public Netty4HttpClientFactory(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
    }

    @Override
    protected void resolveHttpParams0(HttpParams params) {
        this.params = params;
    }

    public Netty4HttpClientFactory setOptions(Map<ChannelOption<?>, ?> options) {
        if (options == null) {
            throw new IllegalArgumentException("'options' must not be empty");
        }
        this.options = options;
        return this;
    }

    private Bootstrap getBootstrap() {
        if (this.bootstrap == null) {
            this.bootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)this.bootstrap.group(this.eventLoopGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel channel) throws Exception {
                    ChannelPipeline pipeline = channel.pipeline();
                    if (Netty4HttpClientFactory.this.params != null) {
                        channel.config().setConnectTimeoutMillis(Netty4HttpClientFactory.this.params.getConnectTimeout());
                        if (Netty4HttpClientFactory.this.options != null) {
                            channel.config().setOptions(Netty4HttpClientFactory.this.options);
                        }
                        pipeline.addLast(new ChannelHandler[]{new ReadTimeoutHandler((long)Netty4HttpClientFactory.this.params.getReadTimeout(), TimeUnit.MILLISECONDS)});
                    }
                    pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
                    pipeline.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
                    pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                    pipeline.addLast(new ChannelHandler[]{new HttpResponseDecoder()});
                    pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
                }
            });
        }
        return this.bootstrap;
    }

    @Override
    public HttpClient newInstance() {
        return new Netty4HttpClient(this.getBootstrap(), this.params);
    }
}

