/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.http.support.netty;

import com.foxinmy.weixin4j.http.AbstractHttpClient;
import com.foxinmy.weixin4j.http.HttpClientException;
import com.foxinmy.weixin4j.http.HttpHeaders;
import com.foxinmy.weixin4j.http.HttpParams;
import com.foxinmy.weixin4j.http.HttpRequest;
import com.foxinmy.weixin4j.http.HttpResponse;
import com.foxinmy.weixin4j.http.entity.HttpEntity;
import com.foxinmy.weixin4j.http.factory.HttpClientFactory;
import com.foxinmy.weixin4j.http.support.netty.Netty4HttpResponse;
import com.foxinmy.weixin4j.util.Consts;
import com.foxinmy.weixin4j.util.SettableFuture;
import com.foxinmy.weixin4j.util.StringUtil;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

public class Netty4HttpClient
extends AbstractHttpClient {
    private final Bootstrap bootstrap;
    private final HttpParams params;

    public Netty4HttpClient(Bootstrap bootstrap, HttpParams params) {
        this.bootstrap = bootstrap;
        this.params = params;
    }

    @Override
    public HttpResponse execute(final HttpRequest request) throws HttpClientException {
        HttpResponse response = null;
        try {
            final URI uri = request.getURI();
            final SettableFuture future = new SettableFuture();
            ChannelFutureListener listener = new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture) throws Exception {
                    if (channelFuture.isSuccess()) {
                        Channel channel = channelFuture.channel();
                        if ("https".equals(uri.getScheme())) {
                            SSLContext sslContext = Netty4HttpClient.this.params != null && Netty4HttpClient.this.params.getSSLContext() != null ? Netty4HttpClient.this.params.getSSLContext() : HttpClientFactory.allowSSLContext();
                            SSLEngine sslEngine = sslContext.createSSLEngine();
                            sslEngine.setUseClientMode(true);
                            channel.pipeline().addFirst(new ChannelHandler[]{new SslHandler(sslEngine)});
                        }
                        channel.pipeline().addLast(new ChannelHandler[]{new RequestHandler(future)});
                        DefaultHttpRequest uriRequest = Netty4HttpClient.this.createRequest(request);
                        channel.writeAndFlush((Object)uriRequest);
                    } else {
                        future.setException(channelFuture.cause());
                    }
                }
            };
            InetSocketAddress address = this.params != null && this.params.getProxy() != null ? (InetSocketAddress)this.params.getProxy().address() : new InetSocketAddress(InetAddress.getByName(uri.getHost()), this.getPort(uri));
            this.bootstrap.connect((SocketAddress)address).addListener((GenericFutureListener)listener);
            response = (HttpResponse)future.get();
            this.handleResponse(response);
        }
        catch (IOException e) {
            throw new HttpClientException("I/O error on " + request.getMethod().name() + " request for \"" + request.getURI().toString() + "\":" + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new HttpClientException("Execute error on " + request.getMethod().name() + " request for \"" + request.getURI().toString() + "\":" + e.getMessage(), e);
        }
        catch (ExecutionException e) {
            throw new HttpClientException("Execute error on " + request.getMethod().name() + " request for \"" + request.getURI().toString() + "\":" + e.getMessage(), e);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        return response;
    }

    private DefaultHttpRequest createRequest(HttpRequest request) throws IOException {
        HttpHeaders headers;
        String url;
        HttpMethod method = HttpMethod.valueOf((String)request.getMethod().name());
        URI uri = request.getURI();
        String string = url = StringUtil.isBlank(uri.getRawPath()) ? "/" : uri.getRawPath();
        if (StringUtil.isNotBlank(uri.getRawQuery())) {
            url = url + "?" + uri.getRawQuery();
        }
        DefaultHttpRequest uriRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, method, url);
        HttpEntity entity = request.getEntity();
        if (entity != null) {
            ByteBuf byteBuf = ByteBufAllocator.DEFAULT.buffer();
            ByteBufOutputStream out = new ByteBufOutputStream(byteBuf);
            entity.writeTo((OutputStream)out);
            out.flush();
            out.close();
            uriRequest = new DefaultFullHttpRequest(uriRequest.getProtocolVersion(), uriRequest.getMethod(), uriRequest.getUri(), byteBuf);
            if (entity.getContentType() != null) {
                uriRequest.headers().add("Content-Type", (Object)entity.getContentType().toString());
            }
            if (entity.getContentLength() < 0L) {
                uriRequest.headers().add("Transfer-Encoding", (Object)"chunked");
            } else {
                uriRequest.headers().add("Content-Length", (Object)entity.getContentLength());
            }
        }
        if ((headers = request.getHeaders()) == null) {
            headers = new HttpHeaders();
        }
        if (!headers.containsKey("Host")) {
            headers.set("Host", uri.getHost());
        }
        if (!headers.containsKey("Accept")) {
            headers.set("Accept", "*/*");
        }
        if (!headers.containsKey("User-Agent")) {
            headers.set("User-Agent", "netty/httpclient");
        }
        for (Map.Entry<String, List<String>> header : headers.entrySet()) {
            uriRequest.headers().set(header.getKey(), (Iterable)header.getValue());
        }
        uriRequest.headers().set("Accept-Charset", (Object)Consts.UTF_8.displayName());
        uriRequest.headers().set("Connection", (Object)"close");
        return uriRequest;
    }

    private int getPort(URI uri) {
        int port = uri.getPort();
        if (port == -1) {
            if ("http".equalsIgnoreCase(uri.getScheme())) {
                port = 80;
            } else if ("https".equalsIgnoreCase(uri.getScheme())) {
                port = 443;
            }
        }
        return port;
    }

    private static class RequestHandler
    extends SimpleChannelInboundHandler<FullHttpResponse> {
        private final SettableFuture<HttpResponse> future;

        public RequestHandler(SettableFuture<HttpResponse> future) {
            this.future = future;
        }

        protected void channelRead0(ChannelHandlerContext context, FullHttpResponse response) throws Exception {
            byte[] content = null;
            ByteBuf byteBuf = response.content();
            if (byteBuf.hasArray()) {
                content = byteBuf.array();
            } else {
                content = new byte[byteBuf.readableBytes()];
                byteBuf.readBytes(content);
            }
            this.future.set(new Netty4HttpResponse(context, response, content));
        }

        public void exceptionCaught(ChannelHandlerContext context, Throwable cause) throws Exception {
            this.future.setException(cause);
        }
    }
}

