/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.http.support.apache3;

import com.foxinmy.weixin4j.http.AbstractHttpResponse;
import com.foxinmy.weixin4j.http.HttpHeaders;
import com.foxinmy.weixin4j.http.HttpStatus;
import com.foxinmy.weixin4j.http.HttpVersion;
import java.io.IOException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.protocol.Protocol;

public class HttpComponent3Response
extends AbstractHttpResponse {
    private final HttpMethod httpMethod;
    private HttpHeaders headers;
    private HttpVersion protocol;
    private HttpStatus status;

    public HttpComponent3Response(HttpMethod httpMethod) throws IOException {
        super(httpMethod.getResponseBody());
        this.httpMethod = httpMethod;
    }

    @Override
    public HttpHeaders getHeaders() {
        if (this.headers == null) {
            Header[] headers;
            this.headers = new HttpHeaders();
            for (Header header : headers = this.httpMethod.getResponseHeaders()) {
                this.headers.add(header.getName(), header.getValue());
            }
        }
        return this.headers;
    }

    @Override
    public HttpVersion getProtocol() {
        org.apache.commons.httpclient.HttpVersion version = this.httpMethod.getParams().getVersion();
        if (version == null) {
            return null;
        }
        Header connection = this.httpMethod.getResponseHeader("Connection");
        if (this.protocol == null) {
            this.protocol = new HttpVersion("HTTP", version.getMajor(), version.getMinor(), connection != null && "keep-alive".equalsIgnoreCase(connection.getValue()));
        }
        return this.protocol;
    }

    @Override
    public HttpStatus getStatus() {
        if (this.status == null) {
            this.status = new HttpStatus(this.httpMethod.getStatusCode(), this.httpMethod.getStatusText());
        }
        return this.status;
    }

    @Override
    public void close() {
        this.httpMethod.releaseConnection();
        Protocol.unregisterProtocol((String)"https");
    }
}

