/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.http.factory;

import com.foxinmy.weixin4j.http.HttpClient;
import com.foxinmy.weixin4j.http.HttpClientException;
import com.foxinmy.weixin4j.http.HttpParams;
import com.foxinmy.weixin4j.http.factory.SimpleHttpClientFactory;
import com.foxinmy.weixin4j.http.support.apache3.HttpComponent3Factory;
import com.foxinmy.weixin4j.http.support.apache4.HttpComponent4Factory;
import com.foxinmy.weixin4j.http.support.netty.Netty4HttpClientFactory;
import com.foxinmy.weixin4j.http.support.okhttp.OkHttpClientFactory;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;

public abstract class HttpClientFactory {
    private static volatile HttpClientFactory defaultFactory = HttpClientFactory.newDefaultFactory();
    private static volatile HttpParams defaultParams;

    private static HttpClientFactory newDefaultFactory() {
        HttpClientFactory f;
        try {
            f = new Netty4HttpClientFactory();
        }
        catch (Throwable e1) {
            try {
                f = new HttpComponent4Factory();
            }
            catch (Throwable e2) {
                try {
                    f = new HttpComponent3Factory();
                }
                catch (Throwable e3) {
                    try {
                        f = new OkHttpClientFactory();
                    }
                    catch (Throwable e4) {
                        f = new SimpleHttpClientFactory();
                    }
                }
            }
        }
        return f;
    }

    public static HttpClientFactory getDefaultFactory() {
        return defaultFactory;
    }

    public static void setDefaultFactory(HttpClientFactory defaultFactory) {
        if (defaultFactory == null) {
            throw new IllegalArgumentException("'defaultFactory' must not be empty");
        }
        HttpClientFactory.defaultFactory = defaultFactory;
    }

    public static HttpParams getDefaultParams() {
        return defaultParams;
    }

    public static void setDefaultParams(HttpParams params) {
        if (params == null) {
            throw new IllegalArgumentException("'params' must not be empty");
        }
        defaultParams = params;
    }

    public static HttpClient getInstance() {
        return HttpClientFactory.getInstance(defaultParams);
    }

    public static HttpClient getInstance(HttpParams params) {
        HttpClientFactory clientFactory = HttpClientFactory.getDefaultFactory();
        if (params != null) {
            clientFactory.resolveHttpParams(params);
        }
        return clientFactory.newInstance();
    }

    public void resolveHttpParams(HttpParams params) {
        if (params == null) {
            throw new IllegalArgumentException("'params' must not be empty");
        }
        this.resolveHttpParams0(params);
    }

    protected abstract void resolveHttpParams0(HttpParams var1);

    public abstract HttpClient newInstance();

    public static SSLContext allowSSLContext() throws HttpClientException {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new X509TrustManager[]{AllowX509TrustManager.GLOBAL}, new SecureRandom());
            return sslContext;
        }
        catch (NoSuchAlgorithmException e) {
            throw new HttpClientException("Create SSLContext NoSuchAlgorithmException:", e);
        }
        catch (KeyManagementException e) {
            throw new HttpClientException("Create SSLContext KeyManagementException:", e);
        }
    }

    public static class AllowHostnameVerifier
    implements HostnameVerifier {
        public static final HostnameVerifier GLOBAL = new AllowHostnameVerifier();

        private AllowHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    public static class AllowX509TrustManager
    implements X509TrustManager {
        public static final X509TrustManager GLOBAL = new AllowX509TrustManager();

        private AllowX509TrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
        }
    }
}

