/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.http.apache;

import com.foxinmy.weixin4j.http.apache.AbstractContentBody;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class InputStreamBody
extends AbstractContentBody {
    private final InputStream in;
    private final String filename;
    private int contentLength;

    public InputStreamBody(InputStream in, String mimeType, String filename) {
        super(mimeType);
        if (in == null) {
            throw new IllegalArgumentException("Input stream may not be null");
        }
        this.in = in;
        this.filename = filename;
    }

    public InputStreamBody(InputStream in, String filename) {
        this(in, "application/octet-stream", filename);
    }

    public InputStream getInputStream() {
        return this.in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream out) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        try {
            int l;
            byte[] tmp = new byte[4096];
            while ((l = this.in.read(tmp)) != -1) {
                out.write(tmp, 0, l);
                this.contentLength += l;
            }
            out.flush();
        }
        finally {
            this.in.close();
        }
    }

    @Override
    public String getTransferEncoding() {
        return "binary";
    }

    @Override
    public String getCharset() {
        return null;
    }

    @Override
    public long getContentLength() {
        try {
            return Math.max(this.contentLength, this.in.available());
        }
        catch (IOException e) {
            return -1L;
        }
    }

    @Override
    public String getFilename() {
        return this.filename;
    }
}

