/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.http;

import com.foxinmy.weixin4j.http.AbstractHttpClient;
import com.foxinmy.weixin4j.http.HttpClient;
import com.foxinmy.weixin4j.http.HttpClientException;
import com.foxinmy.weixin4j.http.HttpHeaders;
import com.foxinmy.weixin4j.http.HttpParams;
import com.foxinmy.weixin4j.http.HttpRequest;
import com.foxinmy.weixin4j.http.HttpResponse;
import com.foxinmy.weixin4j.http.SimpleHttpResponse;
import com.foxinmy.weixin4j.http.entity.HttpEntity;
import com.foxinmy.weixin4j.http.factory.HttpClientFactory;
import com.foxinmy.weixin4j.util.IOUtil;
import com.foxinmy.weixin4j.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;

public class SimpleHttpClient
extends AbstractHttpClient
implements HttpClient {
    private final HttpParams params;

    public SimpleHttpClient(HttpParams params) {
        this.params = params;
    }

    protected HttpURLConnection createHttpConnection(HttpRequest request) throws IOException {
        URLConnection urlConnection;
        URI uri = request.getURI();
        Proxy proxy = this.params != null ? this.params.getProxy() : null;
        URLConnection uRLConnection = urlConnection = proxy != null ? uri.toURL().openConnection(proxy) : uri.toURL().openConnection();
        if (uri.getScheme().equals("https")) {
            try {
                SSLContext sslContext = null;
                HostnameVerifier hostnameVerifier = null;
                if (this.params != null) {
                    sslContext = this.params.getSSLContext();
                    hostnameVerifier = this.params.getHostnameVerifier();
                }
                if (sslContext == null) {
                    sslContext = HttpClientFactory.allowSSLContext();
                }
                if (hostnameVerifier == null) {
                    hostnameVerifier = HttpClientFactory.AllowHostnameVerifier.GLOBAL;
                }
                HttpsURLConnection connection = (HttpsURLConnection)urlConnection;
                connection.setSSLSocketFactory(sslContext.getSocketFactory());
                connection.setHostnameVerifier(hostnameVerifier);
                return connection;
            }
            catch (HttpClientException e) {
                throw new IOException(e);
            }
        }
        return (HttpURLConnection)urlConnection;
    }

    @Override
    public HttpResponse execute(HttpRequest request) throws HttpClientException {
        HttpResponse response = null;
        try {
            HttpURLConnection connection = this.createHttpConnection(request);
            String method = request.getMethod().name();
            if (this.params != null) {
                connection.setConnectTimeout(this.params.getConnectTimeout());
                connection.setReadTimeout(this.params.getReadTimeout());
            }
            connection.setRequestMethod(method);
            connection.setDoInput(true);
            connection.setInstanceFollowRedirects("GET".equals(method));
            if ("PUT".equals(method) || "POST".equals(method) || "PATCH".equals(method) || "DELETE".equals(method)) {
                connection.setDoOutput(true);
            } else {
                connection.setDoOutput(false);
            }
            HttpHeaders headers = request.getHeaders();
            if (headers == null) {
                headers = new HttpHeaders();
            }
            if (!headers.containsKey("Host")) {
                headers.set("Host", request.getURI().getHost());
            }
            if (!headers.containsKey("Accept")) {
                headers.set("Accept", "*/*");
            }
            if (!headers.containsKey("User-Agent")) {
                headers.set("User-Agent", "jdk/httpclient");
            }
            for (Map.Entry<String, List<String>> header : headers.entrySet()) {
                if ("Cookie".equalsIgnoreCase(header.getKey())) {
                    connection.setRequestProperty(header.getKey(), StringUtil.join((Iterable)header.getValue(), ';'));
                    continue;
                }
                for (String headerValue : header.getValue()) {
                    connection.addRequestProperty(header.getKey(), headerValue != null ? headerValue : "");
                }
            }
            HttpEntity httpEntity = request.getEntity();
            if (httpEntity != null) {
                connection.setUseCaches(false);
                if (httpEntity.getContentLength() > 0L) {
                    connection.setRequestProperty("Content-Length", Long.toString(httpEntity.getContentLength()));
                }
                if (httpEntity.getContentType() != null) {
                    connection.setRequestProperty("Content-Type", httpEntity.getContentType().toString());
                }
            }
            connection.connect();
            if (httpEntity != null) {
                OutputStream output = connection.getOutputStream();
                httpEntity.writeTo(output);
                output.flush();
                output.close();
            }
            InputStream input = connection.getErrorStream() != null ? connection.getErrorStream() : connection.getInputStream();
            byte[] content = IOUtil.toByteArray(input);
            response = new SimpleHttpResponse(connection, content);
            input.close();
            this.handleResponse(response);
        }
        catch (IOException e) {
            throw new HttpClientException("I/O error on " + request.getMethod().name() + " request for \"" + request.getURI().toString() + "\":" + e.getMessage(), e);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        return response;
    }
}

