/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.cache;

import com.foxinmy.weixin4j.cache.CacheStorager;
import com.foxinmy.weixin4j.cache.Cacheable;
import com.whalin.MemCached.MemCachedClient;
import com.whalin.MemCached.SockIOPool;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MemcacheCacheStorager<T extends Cacheable>
implements CacheStorager<T> {
    private final MemCachedClient mc = new MemCachedClient();

    public MemcacheCacheStorager() {
        this(new MemcachePoolConfig());
    }

    public MemcacheCacheStorager(MemcachePoolConfig poolConfig) {
        poolConfig.initSocketIO();
        this.init();
    }

    private void init() {
        if (!this.mc.keyExists("weixin4j_cache_keys")) {
            this.mc.set("weixin4j_cache_keys", new HashSet());
        }
    }

    @Override
    public T lookup(String key) {
        return (T)((Cacheable)this.mc.get(key));
    }

    @Override
    public void caching(String key, T cache) {
        if (cache.getCreateTime() > 0L) {
            this.mc.set(key, cache, new Date(cache.getCreateTime() + cache.getExpires() - 60000L));
        } else {
            this.mc.set(key, cache);
        }
        Set all = (Set)this.mc.get("weixin4j_cache_keys");
        all.add(key);
        this.mc.set("weixin4j_cache_keys", (Object)all);
    }

    @Override
    public T evict(String key) {
        T cache = this.lookup(key);
        this.mc.delete(key);
        Set all = (Set)this.mc.get("weixin4j_cache_keys");
        all.remove(key);
        this.mc.set("weixin4j_cache_keys", (Object)all);
        return cache;
    }

    @Override
    public void clear() {
        Set all = (Set)this.mc.get("weixin4j_cache_keys");
        for (String key : all) {
            this.mc.delete(key);
        }
        this.mc.delete("weixin4j_cache_keys");
    }

    public static class MemcachePoolConfig {
        public static final String HOST = "127.0.0.1";
        public static final int PORT = 11211;
        public static final int WEIGHT = 1;
        public static int minConn = 5;
        public static int initConn = 5;
        public static int maxConn = 100;
        public static int maxIdle = 300000;
        public static long maxBusyTime = 30000L;
        public static int socketTO = 3000;
        public static int socketConnectTO = 3000;
        public static boolean failover = true;
        public static boolean failback = true;
        public static boolean nagle = false;
        public static boolean aliveCheck = false;
        public static final int consistentHash = 3;
        public static final int mainSleep = 30000;
        private static SockIOPool pool = SockIOPool.getInstance();
        private List<MemcacheConfig> configs = new ArrayList<MemcacheConfig>();
        private String[] servers;
        private Integer[] weights;

        public MemcachePoolConfig() {
            this(HOST, 11211, 1);
        }

        public MemcachePoolConfig(String host) {
            this(host, 11211);
        }

        public MemcachePoolConfig(String host, int port) {
            this(host, port, 1);
        }

        public MemcachePoolConfig(String host, int port, int weight) {
            this.configs.add(new MemcacheConfig(host, port, weight));
        }

        public MemcachePoolConfig addServer(String host) {
            return this.addServer(host, 11211, 1);
        }

        public MemcachePoolConfig addServer(String host, int port) {
            return this.addServer(host, port, 1);
        }

        public MemcachePoolConfig addServer(String host, int port, int weight) {
            this.configs.add(new MemcacheConfig(host, port, weight));
            return this;
        }

        private void initConfig() {
            if (this.servers == null || this.weights == null) {
                this.servers = new String[this.configs.size()];
                this.weights = new Integer[this.configs.size()];
                for (int i = 0; i < this.configs.size(); ++i) {
                    this.servers[i] = this.configs.get(i).getServer();
                    this.weights[i] = this.configs.get(i).getWeight();
                }
            }
        }

        private void initSocketIO() {
            pool.setServers(this.getServers());
            pool.setWeights(this.getWeights());
            if (pool.isInitialized()) {
                pool.shutDown();
            }
            pool.initialize();
        }

        public String[] getServers() {
            this.initConfig();
            return this.servers;
        }

        public Integer[] getWeights() {
            this.initConfig();
            return this.weights;
        }

        public String toString() {
            return "MemcachePoolConfig [" + this.configs + "]";
        }

        static {
            pool.setFailback(failback);
            pool.setFailover(failover);
            pool.setMaxBusyTime(maxBusyTime);
            pool.setMaxConn(maxConn);
            pool.setMaxIdle(maxIdle);
            pool.setMinConn(minConn);
            pool.setNagle(nagle);
            pool.setSocketConnectTO(socketConnectTO);
            pool.setSocketTO(socketTO);
            pool.setAliveCheck(aliveCheck);
            pool.setHashingAlg(3);
            pool.setInitConn(initConn);
            pool.setMaintSleep(maxBusyTime);
        }

        private static class MemcacheConfig {
            private String host;
            private int port;
            private int weight;

            public MemcacheConfig(String host, int port, int weight) {
                this.host = host;
                this.port = port;
                this.weight = weight;
            }

            public String getServer() {
                return String.format("%s:%d", this.host, this.port);
            }

            public int getWeight() {
                return this.weight;
            }

            public String toString() {
                return String.format("{%s:%d,%d}", this.host, this.port, this.weight);
            }
        }
    }
}

