/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.cache;

import com.foxinmy.weixin4j.cache.CacheCreator;
import com.foxinmy.weixin4j.cache.CacheStorager;
import com.foxinmy.weixin4j.cache.Cacheable;
import com.foxinmy.weixin4j.exception.WeixinException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class CacheManager<T extends Cacheable> {
    protected final CacheCreator<T> cacheCreator;
    protected final CacheStorager<T> cacheStorager;
    private final ReentrantLock lock = new ReentrantLock();

    public CacheManager(CacheCreator<T> cacheCreator, CacheStorager<T> cacheStorager) {
        this.cacheCreator = cacheCreator;
        this.cacheStorager = cacheStorager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getCache() throws WeixinException {
        T cache;
        block6: {
            String cacheKey = this.cacheCreator.key();
            cache = this.cacheStorager.lookup(cacheKey);
            try {
                if (cache != null || !this.lock.tryLock(3L, TimeUnit.SECONDS)) break block6;
                try {
                    cache = this.cacheStorager.lookup(cacheKey);
                    if (cache == null) {
                        cache = this.cacheCreator.create();
                        this.cacheStorager.caching(cacheKey, cache);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (InterruptedException e) {
                throw new WeixinException("get cache error on lock", e);
            }
        }
        return cache;
    }

    public T refreshCache() throws WeixinException {
        String cacheKey = this.cacheCreator.key();
        T cache = this.cacheCreator.create();
        this.cacheStorager.caching(cacheKey, cache);
        return cache;
    }

    public T evictCache() {
        String cacheKey = this.cacheCreator.key();
        return this.cacheStorager.evict(cacheKey);
    }

    public void clearCache() {
        this.cacheStorager.clear();
    }
}

