/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.api;

import com.foxinmy.weixin4j.api.BaseApi;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.weixin.WeixinRequestExecutor;
import com.foxinmy.weixin4j.model.WeixinPayAccount;
import com.foxinmy.weixin4j.payment.mch.MerchantResult;
import com.foxinmy.weixin4j.sign.WeixinPaymentSignature;
import com.foxinmy.weixin4j.sign.WeixinSignature;
import com.foxinmy.weixin4j.type.IdQuery;
import com.foxinmy.weixin4j.util.RandomUtil;
import com.foxinmy.weixin4j.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class MchApi
extends BaseApi {
    private static final ResourceBundle WEIXIN_BUNDLE = ResourceBundle.getBundle("com/foxinmy/weixin4j/payment/weixin");
    protected final WeixinPayAccount weixinAccount;
    protected final WeixinSignature weixinSignature;
    private volatile WeixinRequestExecutor weixinSSLExecutor;

    public MchApi(WeixinPayAccount weixinAccount) {
        this.weixinAccount = weixinAccount;
        this.weixinSignature = new WeixinPaymentSignature(weixinAccount.getPaySignKey());
    }

    @Override
    protected ResourceBundle weixinBundle() {
        return WEIXIN_BUNDLE;
    }

    protected Map<String, String> createBaseRequestMap(IdQuery idQuery) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appid", this.weixinAccount.getId());
        map.put("mch_id", this.weixinAccount.getMchId());
        map.put("nonce_str", RandomUtil.generateString(16));
        if (StringUtil.isNotBlank(this.weixinAccount.getDeviceInfo())) {
            map.put("device_info", this.weixinAccount.getDeviceInfo());
        }
        if (StringUtil.isNotBlank(this.weixinAccount.getSubId())) {
            map.put("sub_appid", this.weixinAccount.getSubId());
        }
        if (StringUtil.isNotBlank(this.weixinAccount.getSubMchId())) {
            map.put("sub_mch_id", this.weixinAccount.getSubMchId());
        }
        if (idQuery != null) {
            map.put(idQuery.getType().getName(), idQuery.getId());
        }
        return map;
    }

    public WeixinSignature getWeixinSignature() {
        return this.weixinSignature;
    }

    protected WeixinRequestExecutor getWeixinSSLExecutor() throws WeixinException {
        if (this.weixinSSLExecutor == null) {
            try {
                File certificate = new File(this.weixinAccount.getCertificateFile());
                if (!certificate.exists() || !certificate.isFile()) {
                    throw new WeixinException("Invalid certificate file : " + certificate.toString());
                }
                this.weixinSSLExecutor = this.weixinExecutor.createSSLRequestExecutor(this.weixinAccount.getCertificateKey(), new FileInputStream(certificate));
            }
            catch (IOException e) {
                throw new WeixinException("IO Error on createSSLRequestExecutor", e);
            }
        }
        return this.weixinSSLExecutor;
    }

    protected <T extends MerchantResult> void declareMerchant(T merchant) {
        merchant.setAppId(this.weixinAccount.getId());
        merchant.setMchId(this.weixinAccount.getMchId());
        merchant.setDeviceInfo(this.weixinAccount.getDeviceInfo());
        merchant.setSubAppId(this.weixinAccount.getSubId());
        merchant.setSubMchId(this.weixinAccount.getSubMchId());
        merchant.setNonceStr(RandomUtil.generateString(16));
    }
}

