/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.foxinmy.weixin4j.api.MchApi;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.WeixinPayAccount;
import com.foxinmy.weixin4j.payment.mch.CustomsOrder;
import com.foxinmy.weixin4j.payment.mch.CustomsOrderRecord;
import com.foxinmy.weixin4j.payment.mch.CustomsOrderResult;
import com.foxinmy.weixin4j.type.CustomsCity;
import com.foxinmy.weixin4j.type.IdQuery;
import com.foxinmy.weixin4j.xml.ListsuffixResultDeserializer;
import com.foxinmy.weixin4j.xml.XmlStream;

public class CustomsApi
extends MchApi {
    public CustomsApi(WeixinPayAccount weixinAccount) {
        super(weixinAccount);
    }

    public CustomsOrderResult declareCustomsOrder(CustomsOrder customsOrder) throws WeixinException {
        JSONObject para = (JSONObject)JSON.toJSON((Object)customsOrder);
        para.put("appid", (Object)this.weixinAccount.getId());
        para.put("mch_id", (Object)this.weixinAccount.getMchId());
        para.put("sign", (Object)this.weixinSignature.sign(para));
        String param = XmlStream.map2xml(para);
        WeixinResponse response = this.weixinExecutor.post(this.getRequestUri("customsorder_declare_uri"), param);
        return response.getAsObject(new TypeReference<CustomsOrderResult>(){});
    }

    public CustomsOrderRecord queryCustomsOrder(IdQuery idQuery, CustomsCity customsCity) throws WeixinException {
        JSONObject para = new JSONObject();
        para.put("appid", (Object)this.weixinAccount.getId());
        para.put("mch_id", (Object)this.weixinAccount.getMchId());
        para.put(idQuery.getType().getName(), (Object)idQuery.getId());
        para.put("customs", (Object)customsCity.name());
        para.put("sign", (Object)this.weixinSignature.sign(para));
        String param = XmlStream.map2xml(para);
        WeixinResponse response = this.weixinExecutor.post(this.getRequestUri("customsorder_query_uri"), param);
        return ListsuffixResultDeserializer.deserialize(response.getAsString(), CustomsOrderRecord.class);
    }
}

