/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.consul.v1.catalog;

import com.ecwid.consul.SingleUrlParameters;
import com.ecwid.consul.UrlParameters;
import com.ecwid.consul.json.GsonFactory;
import com.ecwid.consul.transport.RawResponse;
import com.ecwid.consul.v1.ConsulRawClient;
import com.ecwid.consul.v1.OperationException;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.catalog.CatalogClient;
import com.ecwid.consul.v1.catalog.model.CatalogDeregistration;
import com.ecwid.consul.v1.catalog.model.CatalogNode;
import com.ecwid.consul.v1.catalog.model.CatalogRegistration;
import com.ecwid.consul.v1.catalog.model.CatalogService;
import com.ecwid.consul.v1.catalog.model.Node;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class CatalogConsulClient
implements CatalogClient {
    private final ConsulRawClient rawClient;

    public CatalogConsulClient(ConsulRawClient rawClient) {
        this.rawClient = rawClient;
    }

    public CatalogConsulClient() {
        this(new ConsulRawClient());
    }

    public CatalogConsulClient(String agentHost) {
        this(new ConsulRawClient(agentHost));
    }

    public CatalogConsulClient(String agentHost, int agentPort) {
        this(new ConsulRawClient(agentHost, agentPort));
    }

    @Override
    public Response<Void> catalogRegister(CatalogRegistration catalogRegistration) {
        String json = GsonFactory.getGson().toJson((Object)catalogRegistration);
        RawResponse rawResponse = this.rawClient.makePutRequest("/v1/catalog/register", json, new UrlParameters[0]);
        if (rawResponse.getStatusCode() == 200) {
            return new Response<Object>(null, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<Void> catalogDeregister(CatalogDeregistration catalogDeregistration, CatalogDeregistration ... catalogDeregistrations) {
        String json;
        RawResponse rawResponse;
        ArrayList<CatalogDeregistration> items = new ArrayList<CatalogDeregistration>();
        items.add(catalogDeregistration);
        if (catalogDeregistrations != null) {
            items.addAll(Arrays.asList(catalogDeregistrations));
        }
        if ((rawResponse = this.rawClient.makePutRequest("/v1/catalog/deregister", json = GsonFactory.getGson().toJson(items), new UrlParameters[0])).getStatusCode() == 200) {
            return new Response<Object>(null, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<List<String>> getCatalogDatacenters() {
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/catalog/datacenters", new UrlParameters[0]);
        if (rawResponse.getStatusCode() == 200) {
            List value = (List)GsonFactory.getGson().fromJson(rawResponse.getContent(), new TypeToken<List<String>>(){}.getType());
            return new Response<List<String>>(value, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<List<Node>> getCatalogNodes(QueryParams queryParams) {
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/catalog/nodes", queryParams);
        if (rawResponse.getStatusCode() == 200) {
            List value = (List)GsonFactory.getGson().fromJson(rawResponse.getContent(), new TypeToken<List<Node>>(){}.getType());
            return new Response<List<Node>>(value, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<Map<String, List<String>>> getCatalogServices(QueryParams queryParams) {
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/catalog/services", queryParams);
        if (rawResponse.getStatusCode() == 200) {
            Map value = (Map)GsonFactory.getGson().fromJson(rawResponse.getContent(), new TypeToken<Map<String, List<String>>>(){}.getType());
            return new Response<Map<String, List<String>>>(value, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<List<CatalogService>> getCatalogService(String serviceName, QueryParams queryParams) {
        return this.getCatalogService(serviceName, null, queryParams);
    }

    @Override
    public Response<List<CatalogService>> getCatalogService(String serviceName, String tag, QueryParams queryParams) {
        SingleUrlParameters tagParam = tag != null ? new SingleUrlParameters("tag", tag) : null;
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/catalog/service/" + serviceName, tagParam, queryParams);
        if (rawResponse.getStatusCode() == 200) {
            List value = (List)GsonFactory.getGson().fromJson(rawResponse.getContent(), new TypeToken<List<CatalogService>>(){}.getType());
            return new Response<List<CatalogService>>(value, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<CatalogNode> getCatalogNode(String nodeName, QueryParams queryParams) {
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/catalog/node/" + nodeName, queryParams);
        if (rawResponse.getStatusCode() == 200) {
            CatalogNode catalogNode = (CatalogNode)GsonFactory.getGson().fromJson(rawResponse.getContent(), CatalogNode.class);
            return new Response<CatalogNode>(catalogNode, rawResponse);
        }
        throw new OperationException(rawResponse);
    }
}

