/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.sparta.xpath;

import com.hp.hpl.sparta.xpath.SimpleStreamTokenizer;
import com.hp.hpl.sparta.xpath.XPath;
import java.io.IOException;

public class XPathException
extends Exception {
    private Throwable cause_ = null;

    public XPathException(XPath xpath, String msg) {
        super(xpath + " " + msg);
    }

    XPathException(XPath xpath, String where, SimpleStreamTokenizer toks, String expected) {
        this(xpath, where + " got \"" + XPathException.toString(toks) + "\" instead of expected " + expected);
    }

    XPathException(XPath xpath, Exception cause) {
        super(xpath + " " + cause);
        this.cause_ = cause;
    }

    @Override
    public Throwable getCause() {
        return this.cause_;
    }

    private static String toString(SimpleStreamTokenizer toks) {
        try {
            StringBuffer result = new StringBuffer();
            result.append(XPathException.tokenToString(toks));
            if (toks.ttype != -1) {
                toks.nextToken();
                result.append(XPathException.tokenToString(toks));
                toks.pushBack();
            }
            return result.toString();
        }
        catch (IOException e) {
            return "(cannot get  info: " + e + ")";
        }
    }

    private static String tokenToString(SimpleStreamTokenizer toks) {
        switch (toks.ttype) {
            case -1: {
                return "<end of expression>";
            }
            case -2: {
                return toks.nval + "";
            }
            case -3: {
                return toks.sval;
            }
        }
        return (char)toks.ttype + "";
    }
}

