/*
 * Decompiled with CFR 0.152.
 */
package com.bckefu.excel.util;

import com.bckefu.excel.graph.entity.ExcelGraph;
import com.bckefu.excel.graph.entity.ExcelGraphElement;
import java.util.List;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Sheet;

public class PoiExcelGraphDataUtil {
    public static void buildGraphData(Sheet dataSourceSheet, ExcelGraph graph) {
        if (graph != null && graph.getCategory() != null && graph.getValueList() != null && graph.getValueList().size() > 0) {
            graph.getCategory().setEndRowNum(dataSourceSheet.getLastRowNum());
            for (ExcelGraphElement e : graph.getValueList()) {
                if (e == null) continue;
                e.setEndRowNum(dataSourceSheet.getLastRowNum());
            }
        }
    }

    public static void buildGraphData(Sheet dataSourceSheet, List<ExcelGraph> graphList) {
        if (graphList != null && graphList.size() > 0) {
            for (ExcelGraph graph : graphList) {
                PoiExcelGraphDataUtil.buildGraphData(dataSourceSheet, graph);
            }
        }
    }

    public static Drawing getDrawingPatriarch(Sheet sheet) {
        if (sheet.getDrawingPatriarch() == null) {
            sheet.createDrawingPatriarch();
        }
        return sheet.getDrawingPatriarch();
    }
}

