/*
 * Decompiled with CFR 0.152.
 */
package com.bckefu.excel.view;

import com.bckefu.excel.view.AbstractExcelView;
import com.bckefu.excel.view.MapGraphExcelView;
import com.bckefu.excel.view.PoiBigExcelExportView;
import com.bckefu.excel.view.PoiMapExcelView;
import com.bckefu.excel.view.PoiSingleExcelView;
import com.bckefu.excel.view.PoiTemplateExcelView;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseView {
    private static final Logger logger = LoggerFactory.getLogger(BaseView.class);

    public static boolean isIE(HttpServletRequest request) {
        return request.getHeader("USER-AGENT").toLowerCase().indexOf("msie") > 0 || request.getHeader("USER-AGENT").toLowerCase().indexOf("rv:11.0") > 0 || request.getHeader("USER-AGENT").toLowerCase().indexOf("edge") > 0;
    }

    public static void render(String fileName, Map<String, Object> model, HttpServletRequest request, HttpServletResponse response, String viewName) {
        AbstractExcelView view = null;
        switch (viewName) {
            case "poiBigExcelView": {
                view = new PoiBigExcelExportView();
                break;
            }
            case "poiExcelView": {
                view = new PoiSingleExcelView();
                break;
            }
            case "": {
                view = new PoiTemplateExcelView();
                break;
            }
            case "poiMapExcelView": {
                view = new PoiMapExcelView();
                break;
            }
            case "MapGraphExcelView": {
                view = new MapGraphExcelView();
                break;
            }
        }
        try {
            ((BaseView)view).renderMergedOutputModel(fileName, model, request, response);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    abstract void renderMergedOutputModel(String var1, Map<String, Object> var2, HttpServletRequest var3, HttpServletResponse var4) throws Exception;
}

