/*
 * Decompiled with CFR 0.152.
 */
package com.bckefu.excel.export.style;

import com.bckefu.excel.entity.params.ExcelExportEntity;
import com.bckefu.excel.entity.params.ExcelForEachParams;
import com.bckefu.excel.export.style.IExcelExportStyler;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Workbook;

public class AbstractExcelExportStyler
implements IExcelExportStyler {
    protected CellStyle stringNoneStyle;
    protected CellStyle stringNoneWrapStyle;
    protected CellStyle stringSeptailStyle;
    protected CellStyle stringSeptailWrapStyle;
    protected Workbook workbook;
    protected static final short STRING_FORMAT = (short)BuiltinFormats.getBuiltinFormat((String)"TEXT");

    protected void createStyles(Workbook workbook) {
        this.stringNoneStyle = this.stringNoneStyle(workbook, false);
        this.stringNoneWrapStyle = this.stringNoneStyle(workbook, true);
        this.stringSeptailStyle = this.stringSeptailStyle(workbook, false);
        this.stringSeptailWrapStyle = this.stringSeptailStyle(workbook, true);
        this.workbook = workbook;
    }

    @Override
    public CellStyle getHeaderStyle(short headerColor) {
        return null;
    }

    @Override
    public CellStyle getTitleStyle(short color) {
        return null;
    }

    @Override
    public CellStyle getStyles(boolean noneStyler, ExcelExportEntity entity) {
        if (noneStyler && (entity == null || entity.isWrap())) {
            return this.stringNoneWrapStyle;
        }
        if (noneStyler) {
            return this.stringNoneStyle;
        }
        if (!noneStyler && (entity == null || entity.isWrap())) {
            return this.stringSeptailWrapStyle;
        }
        return this.stringSeptailStyle;
    }

    @Override
    public CellStyle getStyles(Cell cell, int dataRow, ExcelExportEntity entity, Object obj, Object data) {
        return this.getStyles(dataRow % 2 == 1, entity);
    }

    public CellStyle stringNoneStyle(Workbook workbook, boolean isWarp) {
        return null;
    }

    public CellStyle stringSeptailStyle(Workbook workbook, boolean isWarp) {
        return null;
    }

    @Override
    public CellStyle getTemplateStyles(boolean isSingle, ExcelForEachParams excelForEachParams) {
        return null;
    }
}

