/*
 * Decompiled with CFR 0.152.
 */
package com.bckefu.excel.export;

import com.bckefu.excel.annotation.ExcelTarget;
import com.bckefu.excel.entity.ExportParams;
import com.bckefu.excel.entity.enmus.ExcelType;
import com.bckefu.excel.entity.params.ExcelExportEntity;
import com.bckefu.excel.exception.ExcelExportEnum;
import com.bckefu.excel.exception.ExcelExportException;
import com.bckefu.excel.export.base.ExcelExportServer;
import com.bckefu.excel.export.style.IExcelExportStyler;
import com.bckefu.excel.util.PoiExcelGraphDataUtil;
import com.bckefu.excel.util.PoiPublicUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelBatchExportServer
extends ExcelExportServer {
    Logger logger = LoggerFactory.getLogger(ExcelBatchExportServer.class);
    private static ThreadLocal<ExcelBatchExportServer> THREAD_LOCAL = new ThreadLocal();
    private Workbook workbook;
    private Sheet sheet;
    private List<ExcelExportEntity> excelParams;
    private ExportParams entity;
    private int titleHeight;
    private Drawing patriarch;
    private short rowHeight;
    private int index;

    public void init(ExportParams entity, Class<?> pojoClass) {
        this.logger.debug("ExcelBatchExportServer only support SXSSFWorkbook");
        entity.setType(ExcelType.XSSF);
        this.workbook = new SXSSFWorkbook();
        this.entity = entity;
        this.type = entity.getType();
        this.createSheet(this.workbook, entity, pojoClass);
        if (entity.getMaxNum() == 0) {
            entity.setMaxNum(1000000);
        }
        this.insertDataToSheet(this.workbook, entity, this.excelParams, null, this.sheet);
    }

    public void createSheet(Workbook workbook, ExportParams entity, Class<?> pojoClass) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Excel export start ,class is {}", pojoClass);
            this.logger.debug("Excel version is {}", (Object)(entity.getType().equals((Object)ExcelType.HSSF) ? "03" : "07"));
        }
        if (workbook == null || entity == null || pojoClass == null) {
            throw new ExcelExportException(ExcelExportEnum.PARAMETER_ERROR);
        }
        try {
            this.excelParams = new ArrayList<ExcelExportEntity>();
            if (entity.isAddIndex()) {
                this.excelParams.add(this.indexExcelEntity(entity));
            }
            Field[] fileds = PoiPublicUtil.getClassFields(pojoClass);
            ExcelTarget etarget = pojoClass.getAnnotation(ExcelTarget.class);
            String targetId = etarget == null ? null : etarget.value();
            this.getAllExcelField(entity.getExclusions(), targetId, fileds, this.excelParams, pojoClass, null, null);
            this.sortAllParams(this.excelParams);
            try {
                this.sheet = workbook.createSheet(entity.getSheetName());
            }
            catch (Exception e) {
                this.sheet = workbook.createSheet();
            }
        }
        catch (Exception e) {
            throw new ExcelExportException(ExcelExportEnum.EXPORT_ERROR, (Throwable)e);
        }
    }

    public Workbook appendData(Collection<?> dataSet) {
        if (this.sheet.getLastRowNum() + dataSet.size() > this.entity.getMaxNum()) {
            this.sheet = this.workbook.createSheet();
            this.index = 0;
        }
        for (Object t : dataSet) {
            try {
                this.index += this.createCells(this.patriarch, this.index, t, this.excelParams, this.sheet, this.workbook, this.rowHeight);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                throw new ExcelExportException(ExcelExportEnum.EXPORT_ERROR, (Throwable)e);
            }
        }
        return this.workbook;
    }

    @Override
    protected void insertDataToSheet(Workbook workbook, ExportParams entity, List<ExcelExportEntity> entityList, Collection<?> dataSet, Sheet sheet) {
        try {
            this.dataHanlder = entity.getDataHanlder();
            if (this.dataHanlder != null && this.dataHanlder.getNeedHandlerFields() != null) {
                this.needHanlderList = Arrays.asList(this.dataHanlder.getNeedHandlerFields());
            }
            this.setExcelExportStyler((IExcelExportStyler)entity.getStyle().getConstructor(Workbook.class).newInstance(workbook));
            this.patriarch = PoiExcelGraphDataUtil.getDrawingPatriarch(sheet);
            ArrayList<ExcelExportEntity> excelParams = new ArrayList<ExcelExportEntity>();
            if (entity.isAddIndex()) {
                excelParams.add(this.indexExcelEntity(entity));
            }
            excelParams.addAll(entityList);
            this.sortAllParams(excelParams);
            this.titleHeight = this.index = entity.isCreateHeadRows() ? this.createHeaderAndTitle(entity, sheet, workbook, excelParams) : 0;
            this.setCellWith(excelParams, sheet);
            this.rowHeight = this.getRowHeight(excelParams);
            this.setCurrentIndex(1);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new ExcelExportException(ExcelExportEnum.EXPORT_ERROR, e.getCause());
        }
    }

    public static ExcelBatchExportServer getExcelBatchExportServer(ExportParams entity, Class<?> pojoClass) {
        if (THREAD_LOCAL.get() == null) {
            ExcelBatchExportServer batchServer = new ExcelBatchExportServer();
            batchServer.init(entity, pojoClass);
            THREAD_LOCAL.set(batchServer);
        }
        return THREAD_LOCAL.get();
    }

    public void closeExportBigExcel() {
        if (this.entity.getFreezeCol() != 0) {
            this.sheet.createFreezePane(this.entity.getFreezeCol(), 0, this.entity.getFreezeCol(), 0);
        }
        if (this.entity.getFreezeRow() != 0) {
            this.sheet.createFreezePane(0, this.entity.getFreezeRow());
        }
        this.mergeCells(this.sheet, this.excelParams, this.titleHeight);
        this.addStatisticsRow(this.getExcelExportStyler().getStyles(true, null), this.sheet);
        THREAD_LOCAL.remove();
    }
}

