/*
 * Decompiled with CFR 0.152.
 */
package com.bckefu.excel.export.style;

import com.bckefu.excel.export.style.AbstractExcelExportStyler;
import com.bckefu.excel.export.style.IExcelExportStyler;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelExportStylerBorderImpl
extends AbstractExcelExportStyler
implements IExcelExportStyler {
    public ExcelExportStylerBorderImpl(Workbook workbook) {
        super.createStyles(workbook);
    }

    @Override
    public CellStyle getHeaderStyle(short color) {
        CellStyle titleStyle = this.workbook.createCellStyle();
        Font font = this.workbook.createFont();
        font.setFontHeightInPoints((short)12);
        titleStyle.setFont(font);
        titleStyle.setBorderLeft(BorderStyle.valueOf((String)"1"));
        titleStyle.setBorderRight(BorderStyle.valueOf((String)"1"));
        titleStyle.setBorderBottom(BorderStyle.valueOf((String)"1"));
        titleStyle.setBorderTop(BorderStyle.valueOf((String)"1"));
        titleStyle.setAlignment(HorizontalAlignment.CENTER);
        titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        return titleStyle;
    }

    @Override
    public CellStyle stringNoneStyle(Workbook workbook, boolean isWarp) {
        CellStyle style = workbook.createCellStyle();
        style.setBorderLeft(BorderStyle.valueOf((String)"1"));
        style.setBorderRight(BorderStyle.valueOf((String)"1"));
        style.setBorderBottom(BorderStyle.valueOf((String)"1"));
        style.setBorderTop(BorderStyle.valueOf((String)"1"));
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setDataFormat(STRING_FORMAT);
        if (isWarp) {
            style.setWrapText(true);
        }
        return style;
    }

    @Override
    public CellStyle getTitleStyle(short color) {
        CellStyle titleStyle = this.workbook.createCellStyle();
        titleStyle.setBorderLeft(BorderStyle.valueOf((String)"1"));
        titleStyle.setBorderRight(BorderStyle.valueOf((String)"1"));
        titleStyle.setBorderBottom(BorderStyle.valueOf((String)"1"));
        titleStyle.setBorderTop(BorderStyle.valueOf((String)"1"));
        titleStyle.setAlignment(HorizontalAlignment.CENTER);
        titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        titleStyle.setWrapText(true);
        return titleStyle;
    }

    @Override
    public CellStyle stringSeptailStyle(Workbook workbook, boolean isWarp) {
        return isWarp ? this.stringNoneWrapStyle : this.stringNoneStyle;
    }
}

