/*
 * Decompiled with CFR 0.152.
 */
package com.bckefu.excel;

import com.bckefu.excel.entity.ExportParams;
import com.bckefu.excel.entity.TemplateExportParams;
import com.bckefu.excel.entity.enmus.ExcelType;
import com.bckefu.excel.entity.params.ExcelExportEntity;
import com.bckefu.excel.export.ExcelBatchExportServer;
import com.bckefu.excel.export.base.ExcelExportServer;
import com.bckefu.excel.export.template.ExcelExportOfTemplateUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelExportUtil {
    private ExcelExportUtil() {
    }

    public static Workbook exportBigExcel(ExportParams entity, Class<?> pojoClass, Collection<?> dataSet) {
        ExcelBatchExportServer batachServer = ExcelBatchExportServer.getExcelBatchExportServer(entity, pojoClass);
        return batachServer.appendData(dataSet);
    }

    public static void closeExportBigExcel() {
        ExcelBatchExportServer batachServer = ExcelBatchExportServer.getExcelBatchExportServer(null, null);
        batachServer.closeExportBigExcel();
    }

    public static Workbook exportExcel(ExportParams entity, Class<?> pojoClass, Collection<?> dataSet) {
        Workbook workbook = ExcelExportUtil.getWorkbook(entity.getType(), dataSet.size());
        new ExcelExportServer().createSheet(workbook, entity, pojoClass, dataSet);
        return workbook;
    }

    private static Workbook getWorkbook(ExcelType type, int size) {
        if (ExcelType.HSSF.equals((Object)type)) {
            return new HSSFWorkbook();
        }
        if (size < 100000) {
            return new XSSFWorkbook();
        }
        return new SXSSFWorkbook();
    }

    public static Workbook exportExcel(ExportParams entity, List<ExcelExportEntity> entityList, Collection<? extends Map<?, ?>> dataSet) {
        Workbook workbook = ExcelExportUtil.getWorkbook(entity.getType(), dataSet.size());
        new ExcelExportServer().createSheetForMap(workbook, entity, entityList, dataSet);
        return workbook;
    }

    public static Workbook exportExcel(List<Map<String, Object>> list, ExcelType type) {
        Workbook workbook = ExcelExportUtil.getWorkbook(type, 0);
        for (Map<String, Object> map : list) {
            ExcelExportServer server = new ExcelExportServer();
            server.createSheet(workbook, (ExportParams)map.get("title"), (Class)map.get("entity"), (Collection)map.get("data"));
        }
        return workbook;
    }

    @Deprecated
    public static Workbook exportExcel(TemplateExportParams params, Class<?> pojoClass, Collection<?> dataSet, Map<String, Object> map) {
        return new ExcelExportOfTemplateUtil().createExcleByTemplate(params, pojoClass, dataSet, map);
    }

    public static Workbook exportExcel(TemplateExportParams params, Map<String, Object> map) {
        return new ExcelExportOfTemplateUtil().createExcleByTemplate(params, null, null, map);
    }

    public static Workbook exportExcel(Map<Integer, Map<String, Object>> map, TemplateExportParams params) {
        return new ExcelExportOfTemplateUtil().createExcleByTemplate(params, map);
    }
}

