/*
 * Decompiled with CFR 0.152.
 */
package com.bckefu.excel;

import com.bckefu.excel.entity.ImportParams;
import com.bckefu.excel.entity.result.ExcelImportResult;
import com.bckefu.excel.exception.ExcelImportException;
import com.bckefu.excel.handler.inter.IExcelReadRowHanlder;
import com.bckefu.excel.imports.ExcelImportServer;
import com.bckefu.excel.imports.sax.SaxReadExcel;
import com.bckefu.excel.imports.sax.parse.ISaxRowRead;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelImportUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelImportUtil.class);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> List<T> importExcel(File file, Class<?> pojoClass, ImportParams params) {
        List list;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            list = new ExcelImportServer().importExcelByIs(in, pojoClass, params).getList();
        }
        catch (ExcelImportException e) {
            try {
                throw new ExcelImportException(e.getType(), (Throwable)e);
                catch (Exception e2) {
                    LOGGER.error(e2.getMessage(), (Throwable)e2);
                    throw new ExcelImportException(e2.getMessage(), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)in);
        return list;
    }

    public static <T> List<T> importExcel(InputStream inputstream, Class<?> pojoClass, ImportParams params) throws Exception {
        return new ExcelImportServer().importExcelByIs(inputstream, pojoClass, params).getList();
    }

    public static <T> ExcelImportResult<T> importExcelMore(InputStream inputstream, Class<?> pojoClass, ImportParams params) throws Exception {
        return new ExcelImportServer().importExcelByIs(inputstream, pojoClass, params);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> ExcelImportResult<T> importExcelMore(File file, Class<?> pojoClass, ImportParams params) {
        ExcelImportResult excelImportResult;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            excelImportResult = new ExcelImportServer().importExcelByIs(in, pojoClass, params);
        }
        catch (ExcelImportException e) {
            try {
                throw new ExcelImportException(e.getType(), (Throwable)e);
                catch (Exception e2) {
                    LOGGER.error(e2.getMessage(), (Throwable)e2);
                    throw new ExcelImportException(e2.getMessage(), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)in);
        return excelImportResult;
    }

    public static <T> List<T> importExcelBySax(InputStream inputstream, Class<?> pojoClass, ImportParams params) {
        return new SaxReadExcel().readExcel(inputstream, pojoClass, params, null, null);
    }

    public static void importExcelBySax(InputStream inputstream, Class<?> pojoClass, ImportParams params, IExcelReadRowHanlder hanlder) {
        new SaxReadExcel().readExcel(inputstream, pojoClass, params, null, hanlder);
    }

    public static <T> List<T> importExcelBySax(InputStream inputstream, ISaxRowRead rowRead) {
        return new SaxReadExcel().readExcel(inputstream, null, null, rowRead, null);
    }
}

