/*
 * Decompiled with CFR 0.152.
 */
package com.bckefu.uccc.httpclient;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClient {
    private Logger logger = LoggerFactory.getLogger(HttpClient.class);
    private RestTemplate restTemplate;
    private int readTimeout;
    private int connectTimeout;

    public HttpClient(int readTimeout, int connectTimeout) {
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        factory.setReadTimeout(readTimeout);
        factory.setConnectTimeout(connectTimeout);
        this.restTemplate = new RestTemplate((ClientHttpRequestFactory)factory);
    }

    public HttpClient() {
        this.readTimeout = 5000;
        this.connectTimeout = 15000;
    }

    public String exchange(String url, HttpMethod httpMethod, MediaType mediaType, Map<String, String> parameter, String body, Map<String, String> header) {
        HttpHeaders headers = new HttpHeaders();
        if (header != null) {
            Set<String> keySet = header.keySet();
            for (String key : keySet) {
                headers.add(key, header.get(key));
            }
        }
        if (parameter == null) {
            parameter = new HashMap<String, String>();
        }
        headers.setContentType(mediaType);
        HttpEntity entity = new HttpEntity((Object)JSONObject.parseObject((String)body), (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(url, httpMethod, entity, String.class, parameter);
        return (String)response.getBody();
    }

    public String exchange(String url, HttpMethod httpMethod, Map<String, String> parameter, String body, Map<String, String> header) {
        return this.exchange(url, httpMethod, MediaType.APPLICATION_JSON_UTF8, parameter, body, header);
    }

    public String exchangeText(String url, HttpMethod httpMethod, Map<String, String> parameter, String body, Map<String, String> header) {
        return this.exchange(url, httpMethod, MediaType.TEXT_PLAIN, parameter, body, header);
    }

    public String exchangeXml(String url, HttpMethod httpMethod, Map<String, String> parameter, String body, Map<String, String> header) {
        return this.exchange(url, httpMethod, MediaType.APPLICATION_XML, parameter, body, header);
    }

    public String getExchange(String url, Map<String, String> parameter, Map<String, String> header) {
        return this.exchange(url, HttpMethod.GET, parameter, null, header);
    }

    public String getExchange(String url, Map<String, String> parameter) {
        return this.exchange(url, HttpMethod.GET, parameter, null, null);
    }

    public String postExchange(String url, Map<String, String> parameter, String body, Map<String, String> header) {
        return this.exchange(url, HttpMethod.POST, parameter, body, header);
    }

    public String postExchange(String url, String body, Map<String, String> header) {
        return this.exchange(url, HttpMethod.POST, null, body, header);
    }

    public String postExchange(String url, String body) {
        return this.exchange(url, HttpMethod.POST, null, body, null);
    }

    public String putExchange(String url, Map<String, String> parameter, Map<String, String> header) {
        return this.exchange(url, HttpMethod.PUT, parameter, null, header);
    }
}

