/*
 * Decompiled with CFR 0.152.
 */
package com.bckefu.uccc.hmac;

import java.security.SignatureException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;

public class HmacUtil {
    public static String hmacSha256Hex(String data, String key, String algorithm) {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(), algorithm);
            Mac mac = Mac.getInstance(algorithm);
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(data.getBytes());
            byte[] hexB = new Hex().encode(rawHmac);
            return new String(hexB);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String hmacSha256Hex(String message, String key) throws SignatureException {
        return HmacUtil.hmacSha256Hex(message, key, "HmacSHA256");
    }
}

