/*
 * Decompiled with CFR 0.152.
 */
package com.bckefu.uccc.rsa;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RsaUtil {
    static Logger logger = LoggerFactory.getLogger(RsaUtil.class);
    public static final int KEY_SIZE = 2048;

    public static Map<String, String> generateKeyPair() {
        HashMap<String, String> map = new HashMap<String, String>();
        SecureRandom secureRandom = new SecureRandom();
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(2048, secureRandom);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            PublicKey publicKey = keyPair.getPublic();
            PrivateKey privateKey = keyPair.getPrivate();
            String publicKeyString = RsaUtil.getKeyString(publicKey);
            String privateKeyString = RsaUtil.getKeyString(privateKey);
            map.put("publicKey", publicKeyString);
            map.put("privateKey", privateKeyString);
            RSAPublicKey rsp = (RSAPublicKey)keyPair.getPublic();
            BigInteger bint = rsp.getModulus();
            byte[] b = bint.toByteArray();
            byte[] deBase64Value = Base64.encodeBase64((byte[])b);
            String retValue = new String(deBase64Value);
            map.put("modulus", retValue);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return map;
    }

    private static PublicKey getPublicKey(String key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] keyBytes = Base64.decodeBase64((String)key);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        return publicKey;
    }

    private static PrivateKey getPrivateKey(String key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] keyBytes = Base64.decodeBase64((String)key);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        return privateKey;
    }

    public static String getKeyString(Key key) {
        byte[] keyBytes = key.getEncoded();
        return Base64.encodeBase64String((byte[])keyBytes);
    }

    public static String encrypt(String data, String publicKey) {
        return RsaUtil.encrypt(data, publicKey, "RSA/ECB/PKCS1Padding");
    }

    public static String encrypt(String data, String publicKey, String cipherType) {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(cipherType);
            cipher.init(1, RsaUtil.getPublicKey(publicKey));
            byte[] enBytes = cipher.doFinal(data.getBytes());
            return Base64.encodeBase64String((byte[])enBytes);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String decrypt(String encryptCode, String privateKey) {
        return RsaUtil.decrypt(encryptCode, privateKey, "RSA/ECB/PKCS1Padding");
    }

    public static String decrypt(String encryptCode, String privateKey, String cipherType) {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(2, RsaUtil.getPrivateKey(privateKey));
            byte[] deBytes = cipher.doFinal(Base64.decodeBase64((String)encryptCode));
            return new String(deBytes);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String sign(String plainText, String privateKeyString) {
        PrivateKey privateKey = null;
        try {
            privateKey = RsaUtil.getPrivateKey(privateKeyString);
            Signature signature = Signature.getInstance(privateKey.getAlgorithm());
            signature.initSign(privateKey);
            signature.update(plainText.getBytes());
            return new String(Base64.encodeBase64((byte[])signature.sign()));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        catch (SignatureException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean verifyData(String encryptString, String signatureString, String publicKeyString) {
        PublicKey publicKey = null;
        try {
            publicKey = RsaUtil.getPublicKey(publicKeyString);
            byte[] signatureBytes = Base64.decodeBase64((String)signatureString);
            Signature signature = Signature.getInstance(publicKey.getAlgorithm());
            signature.initVerify(publicKey);
            signature.update(encryptString.getBytes("UTF-8"));
            return signature.verify(signatureBytes);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (SignatureException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        return false;
    }
}

