/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.recipes.lock;

import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.recipes.lock.LockListener;
import org.apache.zookeeper.recipes.lock.ProtocolSupport;
import org.apache.zookeeper.recipes.lock.ZNodeName;
import org.apache.zookeeper.recipes.lock.ZooKeeperOperation;

public class WriteLock
extends ProtocolSupport {
    private static final Logger LOG = Logger.getLogger(WriteLock.class);
    private final String dir;
    private String id;
    private ZNodeName idName;
    private String ownerId;
    private String lastChildId;
    private byte[] data = new byte[]{18, 52};
    private LockListener callback;
    private LockZooKeeperOperation zop;

    public WriteLock(ZooKeeper zookeeper, String dir, List<ACL> acl) {
        super(zookeeper);
        this.dir = dir;
        if (acl != null) {
            this.setAcl((List)acl);
        }
        this.zop = new LockZooKeeperOperation();
    }

    public WriteLock(ZooKeeper zookeeper, String dir, List<ACL> acl, LockListener callback) {
        this(zookeeper, dir, acl);
        this.callback = callback;
    }

    public LockListener getLockListener() {
        return this.callback;
    }

    public void setLockListener(LockListener callback) {
        this.callback = callback;
    }

    public synchronized void unlock() throws RuntimeException {
        if (!this.isClosed() && this.id != null) {
            try {
                ZooKeeperOperation zopdel = new ZooKeeperOperation(){

                    @Override
                    public boolean execute() throws KeeperException, InterruptedException {
                        WriteLock.this.zookeeper.delete(WriteLock.this.id, -1);
                        return Boolean.TRUE;
                    }
                };
                zopdel.execute();
            }
            catch (InterruptedException e) {
                LOG.warn((Object)("Caught: " + e), (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (KeeperException.NoNodeException e) {
            }
            catch (KeeperException e) {
                LOG.warn((Object)("Caught: " + (Object)((Object)e)), (Throwable)e);
                throw (RuntimeException)new RuntimeException(e.getMessage()).initCause(e);
            }
            finally {
                if (this.callback != null) {
                    this.callback.lockReleased();
                }
                this.id = null;
            }
        }
    }

    public synchronized boolean lock() throws KeeperException, InterruptedException {
        if (this.isClosed()) {
            return false;
        }
        this.ensurePathExists(this.dir);
        return (Boolean)this.retryOperation(this.zop);
    }

    public String getDir() {
        return this.dir;
    }

    public boolean isOwner() {
        return this.id != null && this.ownerId != null && this.id.equals(this.ownerId);
    }

    public String getId() {
        return this.id;
    }

    private class LockZooKeeperOperation
    implements ZooKeeperOperation {
        private LockZooKeeperOperation() {
        }

        private void findPrefixInChildren(String prefix, ZooKeeper zookeeper, String dir) throws KeeperException, InterruptedException {
            List names = zookeeper.getChildren(dir, false);
            for (String name : names) {
                if (!name.startsWith(prefix)) continue;
                WriteLock.this.id = name;
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)("Found id created last time: " + WriteLock.this.id));
                break;
            }
            if (WriteLock.this.id == null) {
                WriteLock.this.id = zookeeper.create(dir + "/" + prefix, WriteLock.this.data, WriteLock.this.getAcl(), CreateMode.EPHEMERAL_SEQUENTIAL);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Created id: " + WriteLock.this.id));
                }
            }
        }

        @Override
        public boolean execute() throws KeeperException, InterruptedException {
            do {
                if (WriteLock.this.id == null) {
                    long sessionId = WriteLock.this.zookeeper.getSessionId();
                    String prefix = "x-" + sessionId + "-";
                    this.findPrefixInChildren(prefix, WriteLock.this.zookeeper, WriteLock.this.dir);
                    WriteLock.this.idName = new ZNodeName(WriteLock.this.id);
                }
                if (WriteLock.this.id == null) continue;
                List names = WriteLock.this.zookeeper.getChildren(WriteLock.this.dir, false);
                if (names.isEmpty()) {
                    LOG.warn((Object)("No children in: " + WriteLock.this.dir + " when we've just " + "created one! Lets recreate it..."));
                    WriteLock.this.id = null;
                    continue;
                }
                TreeSet<ZNodeName> sortedNames = new TreeSet<ZNodeName>();
                for (String name : names) {
                    sortedNames.add(new ZNodeName(WriteLock.this.dir + "/" + name));
                }
                WriteLock.this.ownerId = ((ZNodeName)sortedNames.first()).getName();
                SortedSet<ZNodeName> lessThanMe = sortedNames.headSet(WriteLock.this.idName);
                if (!lessThanMe.isEmpty()) {
                    Stat stat;
                    ZNodeName lastChildName = lessThanMe.last();
                    WriteLock.this.lastChildId = lastChildName.getName();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("watching less than me node: " + WriteLock.this.lastChildId));
                    }
                    if ((stat = WriteLock.this.zookeeper.exists(WriteLock.this.lastChildId, (Watcher)new LockWatcher())) != null) {
                        return Boolean.FALSE;
                    }
                    LOG.warn((Object)("Could not find the stats for less than me: " + lastChildName.getName()));
                    continue;
                }
                if (!WriteLock.this.isOwner()) continue;
                if (WriteLock.this.callback != null) {
                    WriteLock.this.callback.lockAcquired();
                }
                return Boolean.TRUE;
            } while (WriteLock.this.id == null);
            return Boolean.FALSE;
        }
    }

    private class LockWatcher
    implements Watcher {
        private LockWatcher() {
        }

        public void process(WatchedEvent event) {
            LOG.debug((Object)("Watcher fired on path: " + event.getPath() + " state: " + event.getState() + " type " + event.getType()));
            try {
                WriteLock.this.lock();
            }
            catch (Exception e) {
                LOG.warn((Object)("Failed to acquire lock: " + e), (Throwable)e);
            }
        }
    }
}

