/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.core.common.zookeeper.inner;

import com.baidu.disconf.core.common.zookeeper.inner.ConnectionWatcher;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintZookeeperTree
extends ConnectionWatcher {
    protected static final Logger LOGGER = LoggerFactory.getLogger(PrintZookeeperTree.class);
    private static final Charset CHARSET = Charset.forName("UTF-8");

    public PrintZookeeperTree() {
        super(true);
    }

    public void list(String groupName) throws KeeperException, InterruptedException {
        try {
            StringBuffer sb = new StringBuffer();
            int pathLength = StringUtils.countMatches((CharSequence)groupName, (CharSequence)"/");
            for (int i = 0; i < pathLength - 1; ++i) {
                sb.append("\t");
            }
            if (groupName != "/") {
                String node = StringUtils.substringAfterLast((String)groupName, (String)"/");
                sb.append("|----" + node);
                Stat stat = new Stat();
                byte[] data = this.zk.getData(groupName, null, stat);
                if (data != null) {
                    sb.append("\t" + new String(data, CHARSET));
                }
                if (stat != null) {
                    sb.append("\t" + stat.getEphemeralOwner());
                }
            } else {
                sb.append(groupName);
            }
            System.out.println(sb.toString());
            List children = this.zk.getChildren(groupName, false);
            for (String child : children) {
                if (groupName != "/") {
                    this.list(groupName + "/" + child);
                    continue;
                }
                this.list(groupName + child);
            }
        }
        catch (KeeperException.NoNodeException e) {
            LOGGER.info("Group %s does not exist\n", (Object)groupName);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args == null || args.length != 1) {
            LOGGER.error("PrintZookeeperTree argu error!");
            System.exit(2);
        }
        PrintZookeeperTree printZookeeperTree = new PrintZookeeperTree();
        printZookeeperTree.connect(args[0]);
        Thread.sleep(2000L);
        System.out.println("\n\n==================");
        printZookeeperTree.list("/");
        System.out.println("\n\n==================");
        printZookeeperTree.close();
        System.out.println("\n\n==================");
    }
}

