/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.core.common.zookeeper.inner;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionWatcher
implements Watcher {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ConnectionWatcher.class);
    private static final int SESSION_TIMEOUT = 10000;
    private static final int CONNECT_TIMEOUT = 3000;
    protected ZooKeeper zk;
    private CountDownLatch connectedSignal = new CountDownLatch(1);
    private static String internalHost = "";
    private boolean debug = false;

    public ConnectionWatcher(boolean debug) {
        this.debug = debug;
    }

    public void connect(String hosts) throws IOException, InterruptedException {
        internalHost = hosts;
        this.zk = new ZooKeeper(internalHost, 10000, (Watcher)this);
        this.connectedSignal.await(3000L, TimeUnit.MILLISECONDS);
        LOGGER.info("zookeeper: " + hosts + " , connected.");
    }

    public void process(WatchedEvent event) {
        if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
            LOGGER.info("zk SyncConnected");
            this.connectedSignal.countDown();
        } else if (event.getState().equals((Object)Watcher.Event.KeeperState.Disconnected)) {
            LOGGER.warn("zk Disconnected");
        } else if (event.getState().equals((Object)Watcher.Event.KeeperState.Expired)) {
            if (!this.debug) {
                LOGGER.error("zk Expired");
                this.reconnect();
            } else {
                LOGGER.info("zk Expired");
            }
        } else if (event.getState().equals((Object)Watcher.Event.KeeperState.AuthFailed)) {
            LOGGER.error("zk AuthFailed");
        }
    }

    public synchronized void reconnect() {
        LOGGER.info("start to reconnect....");
        int retries = 0;
        while (true) {
            try {
                while (this.zk.getState().equals((Object)ZooKeeper.States.CLOSED)) {
                    LOGGER.warn("zookeeper lost connection, reconnect");
                    this.close();
                    this.connect(internalHost);
                }
            }
            catch (Exception e) {
                LOGGER.error(retries + "\t" + e.toString());
                try {
                    int sec = 2;
                    LOGGER.warn("sleep " + sec);
                    TimeUnit.SECONDS.sleep(sec);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
    }

    public void close() throws InterruptedException {
        this.zk.close();
    }

    public ZooKeeper getZk() {
        return this.zk;
    }

    public void setZk(ZooKeeper zk) {
        this.zk = zk;
    }
}

