/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.core.common.utils;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassLoaderUtil {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ClassLoaderUtil.class);
    private static String classPath = "";
    private static ClassLoader loader = Thread.currentThread().getContextClassLoader();

    private ClassLoaderUtil() {
    }

    private static void addCurrentWorkingDir2Classpath(String path2Added) {
        try {
            URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{new File(path2Added).toURI().toURL()}, loader);
            Thread.currentThread().setContextClassLoader(urlClassLoader);
        }
        catch (Exception e) {
            LOGGER.warn(e.toString());
        }
    }

    public static String getClassPath() {
        return classPath;
    }

    public static ClassLoader getLoader() {
        return loader;
    }

    static {
        if (loader == null) {
            LOGGER.info("using system class loader!");
            loader = ClassLoader.getSystemClassLoader();
        }
        try {
            URL url = loader.getResource("");
            File f = new File(url.toURI());
            classPath = f.getAbsolutePath();
            classPath = URLDecoder.decode(classPath, "utf-8");
            if (classPath.contains(".jar!")) {
                LOGGER.warn("using config file inline jar!" + classPath);
                classPath = System.getProperty("user.dir");
                ClassLoaderUtil.addCurrentWorkingDir2Classpath(classPath);
            }
        }
        catch (Exception e) {
            LOGGER.warn("cannot get classpath using getResource(), now using user.dir");
            classPath = System.getProperty("user.dir");
            ClassLoaderUtil.addCurrentWorkingDir2Classpath(classPath);
        }
        LOGGER.info("classpath: {}", (Object)classPath);
    }
}

