/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.core.common.restful.retry.impl;

import com.baidu.disconf.core.common.restful.core.UnreliableInterface;
import com.baidu.disconf.core.common.restful.retry.RetryStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryStrategyRoundBin
implements RetryStrategy {
    protected static final Logger LOGGER = LoggerFactory.getLogger(RetryStrategyRoundBin.class);

    @Override
    public <T> T retry(UnreliableInterface unreliableImpl, int retryTimes, int sleepSeconds) throws Exception {
        for (int cur_time = 0; cur_time < retryTimes; ++cur_time) {
            try {
                return unreliableImpl.call();
            }
            catch (Exception e) {
                LOGGER.warn("cannot reach, will retry " + cur_time + " .... " + e.toString());
                try {
                    Thread.sleep(sleepSeconds * 1000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        LOGGER.warn("finally failed....");
        throw new Exception();
    }
}

