/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.core.common.restful.core;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteUrl {
    private String url;
    private List<String> serverList;
    private List<URL> urls = new ArrayList<URL>();
    protected static final Logger LOGGER = LoggerFactory.getLogger(RemoteUrl.class);

    public RemoteUrl(String url, List<String> serverList) {
        this.url = url;
        this.serverList = serverList;
        for (String server : serverList) {
            try {
                if (!server.startsWith("http://") && !server.startsWith("https://")) {
                    server = "http://" + server;
                }
                this.urls.add(new URL(server + url));
            }
            catch (MalformedURLException e) {
                LOGGER.error(e.toString());
            }
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public List<String> getServerList() {
        return this.serverList;
    }

    public void setServerList(List<String> serverList) {
        this.serverList = serverList;
    }

    public List<URL> getUrls() {
        return this.urls;
    }

    public String toString() {
        return "RemoteUrl [url=" + this.url + ", serverList=" + this.serverList + ", urls=" + this.urls + "]";
    }
}

