/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.CreateNetworkAclEntryRequest;
import com.amazonaws.services.ec2.model.IcmpTypeCode;
import com.amazonaws.services.ec2.model.PortRange;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateNetworkAclEntryRequestMarshaller
implements Marshaller<Request<CreateNetworkAclEntryRequest>, CreateNetworkAclEntryRequest> {
    public Request<CreateNetworkAclEntryRequest> marshall(CreateNetworkAclEntryRequest createNetworkAclEntryRequest) {
        PortRange portRangePortRange;
        IcmpTypeCode icmpTypeCodeIcmpTypeCode;
        if (createNetworkAclEntryRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createNetworkAclEntryRequest, "AmazonEC2");
        request.addParameter("Action", "CreateNetworkAclEntry");
        request.addParameter("Version", "2014-09-01");
        if (createNetworkAclEntryRequest.getNetworkAclId() != null) {
            request.addParameter("NetworkAclId", StringUtils.fromString((String)createNetworkAclEntryRequest.getNetworkAclId()));
        }
        if (createNetworkAclEntryRequest.getRuleNumber() != null) {
            request.addParameter("RuleNumber", StringUtils.fromInteger((Integer)createNetworkAclEntryRequest.getRuleNumber()));
        }
        if (createNetworkAclEntryRequest.getProtocol() != null) {
            request.addParameter("Protocol", StringUtils.fromString((String)createNetworkAclEntryRequest.getProtocol()));
        }
        if (createNetworkAclEntryRequest.getRuleAction() != null) {
            request.addParameter("RuleAction", StringUtils.fromString((String)createNetworkAclEntryRequest.getRuleAction()));
        }
        if (createNetworkAclEntryRequest.isEgress() != null) {
            request.addParameter("Egress", StringUtils.fromBoolean((Boolean)createNetworkAclEntryRequest.isEgress()));
        }
        if (createNetworkAclEntryRequest.getCidrBlock() != null) {
            request.addParameter("CidrBlock", StringUtils.fromString((String)createNetworkAclEntryRequest.getCidrBlock()));
        }
        if ((icmpTypeCodeIcmpTypeCode = createNetworkAclEntryRequest.getIcmpTypeCode()) != null) {
            if (icmpTypeCodeIcmpTypeCode.getType() != null) {
                request.addParameter("Icmp.Type", StringUtils.fromInteger((Integer)icmpTypeCodeIcmpTypeCode.getType()));
            }
            if (icmpTypeCodeIcmpTypeCode.getCode() != null) {
                request.addParameter("Icmp.Code", StringUtils.fromInteger((Integer)icmpTypeCodeIcmpTypeCode.getCode()));
            }
        }
        if ((portRangePortRange = createNetworkAclEntryRequest.getPortRange()) != null) {
            if (portRangePortRange.getFrom() != null) {
                request.addParameter("PortRange.From", StringUtils.fromInteger((Integer)portRangePortRange.getFrom()));
            }
            if (portRangePortRange.getTo() != null) {
                request.addParameter("PortRange.To", StringUtils.fromInteger((Integer)portRangePortRange.getTo()));
            }
        }
        return request;
    }
}

