/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.store;

import com.alibaba.rocketmq.common.UtilAll;
import com.alibaba.rocketmq.store.AllocateMapedFileService;
import com.alibaba.rocketmq.store.MapedFile;
import com.alibaba.rocketmq.store.ReferenceResource;
import com.alibaba.rocketmq.store.SelectMapedBufferResult;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapedFileQueue {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    private static final Logger logError = LoggerFactory.getLogger((String)"RocketmqStoreError");
    private static final int DeleteFilesBatchMax = 10;
    private final String storePath;
    private final int mapedFileSize;
    private final List<MapedFile> mapedFiles = new ArrayList<MapedFile>();
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final AllocateMapedFileService allocateMapedFileService;
    private long committedWhere = 0L;
    private volatile long storeTimestamp = 0L;

    public MapedFileQueue(String storePath, int mapedFileSize, AllocateMapedFileService allocateMapedFileService) {
        this.storePath = storePath;
        this.mapedFileSize = mapedFileSize;
        this.allocateMapedFileService = allocateMapedFileService;
    }

    public MapedFile getMapedFileByTime(long timestamp) {
        Object[] mfs = this.copyMapedFiles(0);
        if (null == mfs) {
            return null;
        }
        for (int i = 0; i < mfs.length; ++i) {
            MapedFile mapedFile = (MapedFile)mfs[i];
            if (mapedFile.getLastModifiedTimestamp() < timestamp) continue;
            return mapedFile;
        }
        return (MapedFile)mfs[mfs.length - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] copyMapedFiles(int reservedMapedFiles) {
        Object[] mfs = null;
        try {
            this.readWriteLock.readLock().lock();
            if (this.mapedFiles.size() <= reservedMapedFiles) {
                Object[] objectArray = null;
                return objectArray;
            }
            mfs = this.mapedFiles.toArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
        return mfs;
    }

    public void truncateDirtyFiles(long offset) {
        ArrayList<MapedFile> willRemoveFiles = new ArrayList<MapedFile>();
        for (MapedFile file : this.mapedFiles) {
            long fileTailOffset = file.getFileFromOffset() + (long)this.mapedFileSize;
            if (fileTailOffset <= offset) continue;
            if (offset >= file.getFileFromOffset()) {
                file.setWrotePostion((int)(offset % (long)this.mapedFileSize));
                file.setCommittedPosition((int)(offset % (long)this.mapedFileSize));
                continue;
            }
            file.destroy(1000L);
            willRemoveFiles.add(file);
        }
        this.deleteExpiredFile(willRemoveFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteExpiredFile(List<MapedFile> files) {
        if (!files.isEmpty()) {
            try {
                this.readWriteLock.writeLock().lock();
                for (MapedFile file : files) {
                    if (this.mapedFiles.remove(file)) continue;
                    log.error("deleteExpiredFile remove failed.");
                    break;
                }
            }
            catch (Exception e) {
                log.error("deleteExpiredFile has exception.", (Throwable)e);
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }
    }

    public boolean load() {
        File dir = new File(this.storePath);
        Object[] files = dir.listFiles();
        if (files != null) {
            Arrays.sort(files);
            for (Object file : files) {
                if (((File)file).length() != (long)this.mapedFileSize) {
                    log.warn(file + "\t" + ((File)file).length() + " length not matched message store config value, ignore it");
                    return true;
                }
                try {
                    MapedFile mapedFile = new MapedFile(((File)file).getPath(), this.mapedFileSize);
                    mapedFile.setWrotePostion(this.mapedFileSize);
                    mapedFile.setCommittedPosition(this.mapedFileSize);
                    this.mapedFiles.add(mapedFile);
                    log.info("load " + ((File)file).getPath() + " OK");
                }
                catch (IOException e) {
                    log.error("load file " + file + " error", (Throwable)e);
                    return false;
                }
            }
        }
        return true;
    }

    public long howMuchFallBehind() {
        MapedFile mapedFile;
        if (this.mapedFiles.isEmpty()) {
            return 0L;
        }
        long committed = this.committedWhere;
        if (committed != 0L && (mapedFile = this.getLastMapedFile()) != null) {
            return mapedFile.getFileFromOffset() + (long)mapedFile.getWrotePostion() - committed;
        }
        return 0L;
    }

    public MapedFile getLastMapedFile() {
        return this.getLastMapedFile(0L);
    }

    public MapedFile getLastMapedFile(long startOffset) {
        long createOffset = -1L;
        MapedFile mapedFileLast = null;
        this.readWriteLock.readLock().lock();
        if (this.mapedFiles.isEmpty()) {
            createOffset = startOffset - startOffset % (long)this.mapedFileSize;
        } else {
            mapedFileLast = this.mapedFiles.get(this.mapedFiles.size() - 1);
        }
        this.readWriteLock.readLock().unlock();
        if (mapedFileLast != null && mapedFileLast.isFull()) {
            createOffset = mapedFileLast.getFileFromOffset() + (long)this.mapedFileSize;
        }
        if (createOffset != -1L) {
            String nextFilePath = this.storePath + File.separator + UtilAll.offset2FileName((long)createOffset);
            String nextNextFilePath = this.storePath + File.separator + UtilAll.offset2FileName((long)(createOffset + (long)this.mapedFileSize));
            MapedFile mapedFile = null;
            if (this.allocateMapedFileService != null) {
                mapedFile = this.allocateMapedFileService.putRequestAndReturnMapedFile(nextFilePath, nextNextFilePath, this.mapedFileSize);
            } else {
                try {
                    mapedFile = new MapedFile(nextFilePath, this.mapedFileSize);
                }
                catch (IOException e) {
                    log.error("create mapedfile exception", (Throwable)e);
                }
            }
            if (mapedFile != null) {
                this.readWriteLock.writeLock().lock();
                if (this.mapedFiles.isEmpty()) {
                    mapedFile.setFirstCreateInQueue(true);
                }
                this.mapedFiles.add(mapedFile);
                this.readWriteLock.writeLock().unlock();
            }
            return mapedFile;
        }
        return mapedFileLast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMinOffset() {
        try {
            this.readWriteLock.readLock().lock();
            if (!this.mapedFiles.isEmpty()) {
                long l = this.mapedFiles.get(0).getFileFromOffset();
                return l;
            }
        }
        catch (Exception e) {
            log.error("getMinOffset has exception.", (Throwable)e);
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxOffset() {
        try {
            this.readWriteLock.readLock().lock();
            if (!this.mapedFiles.isEmpty()) {
                int lastIndex = this.mapedFiles.size() - 1;
                MapedFile mapedFile = this.mapedFiles.get(lastIndex);
                long l = mapedFile.getFileFromOffset() + (long)mapedFile.getWrotePostion();
                return l;
            }
        }
        catch (Exception e) {
            log.error("getMinOffset has exception.", (Throwable)e);
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
        return 0L;
    }

    public void deleteLastMapedFile() {
        if (!this.mapedFiles.isEmpty()) {
            int lastIndex = this.mapedFiles.size() - 1;
            MapedFile mapedFile = this.mapedFiles.get(lastIndex);
            mapedFile.destroy(1000L);
            this.mapedFiles.remove(mapedFile);
            log.info("on recover, destroy a logic maped file " + mapedFile.getFileName());
        }
    }

    public int deleteExpiredFileByTime(long expiredTime, int deleteFilesInterval, long intervalForcibly, boolean cleanImmediately) {
        Object[] mfs = this.copyMapedFiles(0);
        if (null == mfs) {
            return 0;
        }
        int mfsLength = mfs.length - 1;
        int deleteCount = 0;
        ArrayList<MapedFile> files = new ArrayList<MapedFile>();
        if (null != mfs) {
            for (int i = 0; i < mfsLength; ++i) {
                MapedFile mapedFile = (MapedFile)mfs[i];
                long liveMaxTimestamp = mapedFile.getLastModifiedTimestamp() + expiredTime;
                if (System.currentTimeMillis() < liveMaxTimestamp && !cleanImmediately) continue;
                if (!mapedFile.destroy(intervalForcibly)) break;
                files.add(mapedFile);
                ++deleteCount;
                if (files.size() >= 10) break;
                if (deleteFilesInterval <= 0 || i + 1 >= mfsLength) continue;
                try {
                    Thread.sleep(deleteFilesInterval);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        this.deleteExpiredFile(files);
        return deleteCount;
    }

    public int deleteExpiredFileByOffset(long offset, int unitSize) {
        Object[] mfs = this.copyMapedFiles(0);
        ArrayList<MapedFile> files = new ArrayList<MapedFile>();
        int deleteCount = 0;
        if (null != mfs) {
            int mfsLength = mfs.length - 1;
            for (int i = 0; i < mfsLength; ++i) {
                boolean destroy = true;
                MapedFile mapedFile = (MapedFile)mfs[i];
                SelectMapedBufferResult result = mapedFile.selectMapedBuffer(this.mapedFileSize - unitSize);
                if (result != null) {
                    long maxOffsetInLogicQueue = result.getByteBuffer().getLong();
                    result.release();
                    boolean bl = destroy = maxOffsetInLogicQueue < offset;
                    if (destroy) {
                        log.info("physic min offset " + offset + ", logics in current mapedfile max offset " + maxOffsetInLogicQueue + ", delete it");
                    }
                } else {
                    log.warn("this being not excuted forever.");
                    break;
                }
                if (!destroy || !mapedFile.destroy(60000L)) break;
                files.add(mapedFile);
                ++deleteCount;
            }
        }
        this.deleteExpiredFile(files);
        return deleteCount;
    }

    public boolean commit(int flushLeastPages) {
        boolean result = true;
        MapedFile mapedFile = this.findMapedFileByOffset(this.committedWhere, true);
        if (mapedFile != null) {
            long tmpTimeStamp = mapedFile.getStoreTimestamp();
            int offset = mapedFile.commit(flushLeastPages);
            long where = mapedFile.getFileFromOffset() + (long)offset;
            result = where == this.committedWhere;
            this.committedWhere = where;
            if (0 == flushLeastPages) {
                this.storeTimestamp = tmpTimeStamp;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapedFile findMapedFileByOffset(long offset, boolean returnFirstOnNotFound) {
        block10: {
            try {
                this.readWriteLock.readLock().lock();
                MapedFile mapedFile = this.getFirstMapedFile();
                if (mapedFile == null) break block10;
                int index = (int)(offset / (long)this.mapedFileSize - mapedFile.getFileFromOffset() / (long)this.mapedFileSize);
                if (index < 0 || index >= this.mapedFiles.size()) {
                    logError.warn("findMapedFileByOffset offset not matched, request Offset: {}, index: {}, mapedFileSize: {}, mapedFiles count: {}, StackTrace: {}", new Object[]{offset, index, this.mapedFileSize, this.mapedFiles.size(), UtilAll.currentStackTrace()});
                }
                try {
                    MapedFile mapedFile2 = this.mapedFiles.get(index);
                    return mapedFile2;
                }
                catch (Exception e) {
                    try {
                        if (returnFirstOnNotFound) {
                            MapedFile mapedFile3 = mapedFile;
                            this.readWriteLock.readLock().unlock();
                            return mapedFile3;
                        }
                    }
                    catch (Exception e2) {
                        log.error("findMapedFileByOffset Exception", (Throwable)e2);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.readWriteLock.readLock().unlock();
            }
        }
        return null;
    }

    private MapedFile getFirstMapedFile() {
        if (this.mapedFiles.isEmpty()) {
            return null;
        }
        return this.mapedFiles.get(0);
    }

    public MapedFile getLastMapedFile2() {
        if (this.mapedFiles.isEmpty()) {
            return null;
        }
        return this.mapedFiles.get(this.mapedFiles.size() - 1);
    }

    public MapedFile findMapedFileByOffset(long offset) {
        return this.findMapedFileByOffset(offset, false);
    }

    public long getMapedMemorySize() {
        long size = 0L;
        Object[] mfs = this.copyMapedFiles(0);
        if (mfs != null) {
            for (Object mf : mfs) {
                if (!((ReferenceResource)mf).isAvailable()) continue;
                size += (long)this.mapedFileSize;
            }
        }
        return size;
    }

    public boolean retryDeleteFirstFile(long intervalForcibly) {
        MapedFile mapedFile = this.getFirstMapedFileOnLock();
        if (mapedFile != null && !mapedFile.isAvailable()) {
            log.warn("the mapedfile was destroyed once, but still alive, " + mapedFile.getFileName());
            boolean result = mapedFile.destroy(intervalForcibly);
            if (result) {
                log.warn("the mapedfile redelete OK, " + mapedFile.getFileName());
                ArrayList<MapedFile> tmps = new ArrayList<MapedFile>();
                tmps.add(mapedFile);
                this.deleteExpiredFile(tmps);
            } else {
                log.warn("the mapedfile redelete Failed, " + mapedFile.getFileName());
            }
            return result;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapedFile getFirstMapedFileOnLock() {
        try {
            this.readWriteLock.readLock().lock();
            MapedFile mapedFile = this.getFirstMapedFile();
            return mapedFile;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void shutdown(long intervalForcibly) {
        this.readWriteLock.readLock().lock();
        for (MapedFile mf : this.mapedFiles) {
            mf.shutdown(intervalForcibly);
        }
        this.readWriteLock.readLock().unlock();
    }

    public void destroy() {
        this.readWriteLock.writeLock().lock();
        for (MapedFile mf : this.mapedFiles) {
            mf.destroy(3000L);
        }
        this.mapedFiles.clear();
        this.committedWhere = 0L;
        File file = new File(this.storePath);
        if (file.isDirectory()) {
            file.delete();
        }
        this.readWriteLock.writeLock().unlock();
    }

    public long getCommittedWhere() {
        return this.committedWhere;
    }

    public void setCommittedWhere(long committedWhere) {
        this.committedWhere = committedWhere;
    }

    public long getStoreTimestamp() {
        return this.storeTimestamp;
    }

    public List<MapedFile> getMapedFiles() {
        return this.mapedFiles;
    }

    public int getMapedFileSize() {
        return this.mapedFileSize;
    }
}

