/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.namesrv;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import com.alibaba.rocketmq.common.MQVersion;
import com.alibaba.rocketmq.common.MixAll;
import com.alibaba.rocketmq.common.conflict.PackageConflictDetect;
import com.alibaba.rocketmq.common.namesrv.NamesrvConfig;
import com.alibaba.rocketmq.namesrv.NamesrvController;
import com.alibaba.rocketmq.remoting.netty.NettyServerConfig;
import com.alibaba.rocketmq.remoting.netty.NettySystemConfig;
import com.alibaba.rocketmq.remoting.protocol.RemotingCommand;
import com.alibaba.rocketmq.srvutil.ServerUtil;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamesrvStartup {
    public static Properties properties = null;
    public static CommandLine commandLine = null;

    public static Options buildCommandlineOptions(Options options) {
        Option opt = new Option("c", "configFile", true, "Name server config properties file");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("p", "printConfigItem", false, "Print all config item");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    public static void main(String[] args) {
        NamesrvStartup.main0(args);
    }

    public static NamesrvController main0(String[] args) {
        System.setProperty(RemotingCommand.RemotingVersionKey, Integer.toString(MQVersion.CurrentVersion));
        if (null == System.getProperty("com.rocketmq.remoting.socket.sndbuf.size")) {
            NettySystemConfig.SocketSndbufSize = 2048;
        }
        if (null == System.getProperty("com.rocketmq.remoting.socket.rcvbuf.size")) {
            NettySystemConfig.SocketRcvbufSize = 1024;
        }
        try {
            String file;
            PackageConflictDetect.detectFastjson();
            Options options = ServerUtil.buildCommandlineOptions((Options)new Options());
            commandLine = ServerUtil.parseCmdLine((String)"mqnamesrv", (String[])args, (Options)NamesrvStartup.buildCommandlineOptions(options), (CommandLineParser)new PosixParser());
            if (null == commandLine) {
                System.exit(-1);
                return null;
            }
            NamesrvConfig namesrvConfig = new NamesrvConfig();
            NettyServerConfig nettyServerConfig = new NettyServerConfig();
            nettyServerConfig.setListenPort(9876);
            if (commandLine.hasOption('c') && (file = commandLine.getOptionValue('c')) != null) {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
                properties = new Properties();
                properties.load(in);
                MixAll.properties2Object((Properties)properties, (Object)namesrvConfig);
                MixAll.properties2Object((Properties)properties, (Object)nettyServerConfig);
                System.out.println("load config properties file OK, " + file);
                ((InputStream)in).close();
            }
            if (commandLine.hasOption('p')) {
                MixAll.printObjectProperties(null, (Object)namesrvConfig);
                MixAll.printObjectProperties(null, (Object)nettyServerConfig);
                System.exit(0);
            }
            MixAll.properties2Object((Properties)ServerUtil.commandLine2Properties((CommandLine)commandLine), (Object)namesrvConfig);
            if (null == namesrvConfig.getRocketmqHome()) {
                System.out.println("Please set the ROCKETMQ_HOME variable in your environment to match the location of the RocketMQ installation");
                System.exit(-2);
            }
            LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)lc);
            lc.reset();
            configurator.doConfigure(namesrvConfig.getRocketmqHome() + "/conf/logback_namesrv.xml");
            final Logger log = LoggerFactory.getLogger((String)"RocketmqNamesrv");
            MixAll.printObjectProperties((Logger)log, (Object)namesrvConfig);
            MixAll.printObjectProperties((Logger)log, (Object)nettyServerConfig);
            final NamesrvController controller = new NamesrvController(namesrvConfig, nettyServerConfig);
            boolean initResult = controller.initialize();
            if (!initResult) {
                controller.shutdown();
                System.exit(-3);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){
                private volatile boolean hasShutdown = false;
                private AtomicInteger shutdownTimes = new AtomicInteger(0);

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        log.info("shutdown hook was invoked, " + this.shutdownTimes.incrementAndGet());
                        if (!this.hasShutdown) {
                            this.hasShutdown = true;
                            long begineTime = System.currentTimeMillis();
                            controller.shutdown();
                            long consumingTimeTotal = System.currentTimeMillis() - begineTime;
                            log.info("shutdown hook over, consuming time total(ms): " + consumingTimeTotal);
                        }
                    }
                }
            }, "ShutdownHook"));
            controller.start();
            String tip = "The Name Server boot success.";
            log.info(tip);
            System.out.println(tip);
            return controller;
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }
}

