/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.broker.topic;

import com.alibaba.rocketmq.broker.BrokerController;
import com.alibaba.rocketmq.broker.BrokerPathConfigHelper;
import com.alibaba.rocketmq.common.ConfigManager;
import com.alibaba.rocketmq.common.DataVersion;
import com.alibaba.rocketmq.common.TopicConfig;
import com.alibaba.rocketmq.common.constant.PermName;
import com.alibaba.rocketmq.common.protocol.body.KVTable;
import com.alibaba.rocketmq.common.protocol.body.TopicConfigSerializeWrapper;
import com.alibaba.rocketmq.common.sysflag.TopicSysFlag;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicConfigManager
extends ConfigManager {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqBroker");
    private static final long LockTimeoutMillis = 3000L;
    private final transient Lock lockTopicConfigTable = new ReentrantLock();
    private transient BrokerController brokerController;
    private final ConcurrentHashMap<String, TopicConfig> topicConfigTable = new ConcurrentHashMap(1024);
    private final DataVersion dataVersion = new DataVersion();
    private final Set<String> systemTopicList = new HashSet<String>();

    public TopicConfigManager() {
    }

    public TopicConfigManager(BrokerController brokerController) {
        int perm;
        this.brokerController = brokerController;
        String topic = "SELF_TEST_TOPIC";
        TopicConfig topicConfig = new TopicConfig(topic);
        this.systemTopicList.add(topic);
        topicConfig.setReadQueueNums(1);
        topicConfig.setWriteQueueNums(1);
        this.topicConfigTable.put(topicConfig.getTopicName(), topicConfig);
        if (this.brokerController.getBrokerConfig().isAutoCreateTopicEnable()) {
            topic = "TBW102";
            topicConfig = new TopicConfig(topic);
            this.systemTopicList.add(topic);
            topicConfig.setReadQueueNums(this.brokerController.getBrokerConfig().getDefaultTopicQueueNums());
            topicConfig.setWriteQueueNums(this.brokerController.getBrokerConfig().getDefaultTopicQueueNums());
            perm = 7;
            topicConfig.setPerm(perm);
            this.topicConfigTable.put(topicConfig.getTopicName(), topicConfig);
        }
        topic = "BenchmarkTest";
        topicConfig = new TopicConfig(topic);
        this.systemTopicList.add(topic);
        topicConfig.setReadQueueNums(1024);
        topicConfig.setWriteQueueNums(1024);
        this.topicConfigTable.put(topicConfig.getTopicName(), topicConfig);
        topic = this.brokerController.getBrokerConfig().getBrokerClusterName();
        topicConfig = new TopicConfig(topic);
        this.systemTopicList.add(topic);
        perm = 1;
        if (this.brokerController.getBrokerConfig().isClusterTopicEnable()) {
            perm |= 6;
        }
        topicConfig.setPerm(perm);
        this.topicConfigTable.put(topicConfig.getTopicName(), topicConfig);
        topic = this.brokerController.getBrokerConfig().getBrokerName();
        topicConfig = new TopicConfig(topic);
        this.systemTopicList.add(topic);
        perm = 1;
        if (this.brokerController.getBrokerConfig().isBrokerTopicEnable()) {
            perm |= 6;
        }
        topicConfig.setReadQueueNums(1);
        topicConfig.setWriteQueueNums(1);
        topicConfig.setPerm(perm);
        this.topicConfigTable.put(topicConfig.getTopicName(), topicConfig);
        topic = "OFFSET_MOVED_EVENT";
        topicConfig = new TopicConfig(topic);
        this.systemTopicList.add(topic);
        topicConfig.setReadQueueNums(1);
        topicConfig.setWriteQueueNums(1);
        this.topicConfigTable.put(topicConfig.getTopicName(), topicConfig);
    }

    public boolean isSystemTopic(String topic) {
        return this.systemTopicList.contains(topic);
    }

    public Set<String> getSystemTopic() {
        return this.systemTopicList;
    }

    public boolean isTopicCanSendMessage(String topic) {
        boolean reservedWords = topic.equals("TBW102") || topic.equals(this.brokerController.getBrokerConfig().getBrokerClusterName());
        return !reservedWords;
    }

    public TopicConfig selectTopicConfig(String topic) {
        return this.topicConfigTable.get(topic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TopicConfig createTopicInSendMessageMethod(String topic, String defaultTopic, String remoteAddress, int clientDefaultTopicQueueNums, int topicSysFlag) {
        boolean createNew;
        TopicConfig topicConfig;
        block13: {
            topicConfig = null;
            createNew = false;
            try {
                if (!this.lockTopicConfigTable.tryLock(3000L, TimeUnit.MILLISECONDS)) break block13;
                try {
                    topicConfig = this.topicConfigTable.get(topic);
                    if (topicConfig != null) {
                        TopicConfig topicConfig2 = topicConfig;
                        return topicConfig2;
                    }
                    TopicConfig defaultTopicConfig = this.topicConfigTable.get(defaultTopic);
                    if (defaultTopicConfig != null) {
                        if (PermName.isInherited((int)defaultTopicConfig.getPerm())) {
                            int queueNums;
                            topicConfig = new TopicConfig(topic);
                            int n = queueNums = clientDefaultTopicQueueNums > defaultTopicConfig.getWriteQueueNums() ? defaultTopicConfig.getWriteQueueNums() : clientDefaultTopicQueueNums;
                            if (queueNums < 0) {
                                queueNums = 0;
                            }
                            topicConfig.setReadQueueNums(queueNums);
                            topicConfig.setWriteQueueNums(queueNums);
                            int perm = defaultTopicConfig.getPerm();
                            topicConfig.setPerm(perm &= 0xFFFFFFFE);
                            topicConfig.setTopicSysFlag(topicSysFlag);
                            topicConfig.setTopicFilterType(defaultTopicConfig.getTopicFilterType());
                        } else {
                            log.warn("create new topic failed, because the default topic[" + defaultTopic + "] no perm, " + defaultTopicConfig.getPerm() + " producer: " + remoteAddress);
                        }
                    } else {
                        log.warn("create new topic failed, because the default topic[" + defaultTopic + "] not exist." + " producer: " + remoteAddress);
                    }
                    if (topicConfig != null) {
                        log.info("create new topic by default topic[" + defaultTopic + "], " + topicConfig + " producer: " + remoteAddress);
                        this.topicConfigTable.put(topic, topicConfig);
                        this.dataVersion.nextVersion();
                        createNew = true;
                        this.persist();
                    }
                }
                finally {
                    this.lockTopicConfigTable.unlock();
                }
            }
            catch (InterruptedException e) {
                log.error("createTopicInSendMessageMethod exception", (Throwable)e);
            }
        }
        if (!createNew) return topicConfig;
        this.brokerController.registerBrokerAll(false, true);
        return topicConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TopicConfig createTopicInSendMessageBackMethod(String topic, int clientDefaultTopicQueueNums, int perm, int topicSysFlag) {
        boolean createNew;
        TopicConfig topicConfig;
        block8: {
            topicConfig = this.topicConfigTable.get(topic);
            if (topicConfig != null) {
                return topicConfig;
            }
            createNew = false;
            try {
                if (!this.lockTopicConfigTable.tryLock(3000L, TimeUnit.MILLISECONDS)) break block8;
                try {
                    topicConfig = this.topicConfigTable.get(topic);
                    if (topicConfig != null) {
                        TopicConfig topicConfig2 = topicConfig;
                        return topicConfig2;
                    }
                    topicConfig = new TopicConfig(topic);
                    topicConfig.setReadQueueNums(clientDefaultTopicQueueNums);
                    topicConfig.setWriteQueueNums(clientDefaultTopicQueueNums);
                    topicConfig.setPerm(perm);
                    topicConfig.setTopicSysFlag(topicSysFlag);
                    log.info("create new topic {}", (Object)topicConfig);
                    this.topicConfigTable.put(topic, topicConfig);
                    createNew = true;
                    this.dataVersion.nextVersion();
                    this.persist();
                }
                finally {
                    this.lockTopicConfigTable.unlock();
                }
            }
            catch (InterruptedException e) {
                log.error("createTopicInSendMessageBackMethod exception", (Throwable)e);
            }
        }
        if (!createNew) return topicConfig;
        this.brokerController.registerBrokerAll(false, true);
        return topicConfig;
    }

    public void updateTopicUnitFlag(String topic, boolean unit) {
        TopicConfig topicConfig = this.topicConfigTable.get(topic);
        if (topicConfig != null) {
            int oldTopicSysFlag = topicConfig.getTopicSysFlag();
            if (unit) {
                topicConfig.setTopicSysFlag(TopicSysFlag.setUnitFlag((int)oldTopicSysFlag));
            } else {
                topicConfig.setTopicSysFlag(TopicSysFlag.clearUnitFlag((int)oldTopicSysFlag));
            }
            log.info("update topic sys flag. oldTopicSysFlag={}, newTopicSysFlag", (Object)oldTopicSysFlag, (Object)topicConfig.getTopicSysFlag());
            this.topicConfigTable.put(topic, topicConfig);
            this.dataVersion.nextVersion();
            this.persist();
            this.brokerController.registerBrokerAll(false, true);
        }
    }

    public void updateTopicUnitSubFlag(String topic, boolean hasUnitSub) {
        TopicConfig topicConfig = this.topicConfigTable.get(topic);
        if (topicConfig != null) {
            int oldTopicSysFlag = topicConfig.getTopicSysFlag();
            if (hasUnitSub) {
                topicConfig.setTopicSysFlag(TopicSysFlag.setUnitSubFlag((int)oldTopicSysFlag));
            }
            log.info("update topic sys flag. oldTopicSysFlag={}, newTopicSysFlag", (Object)oldTopicSysFlag, (Object)topicConfig.getTopicSysFlag());
            this.topicConfigTable.put(topic, topicConfig);
            this.dataVersion.nextVersion();
            this.persist();
            this.brokerController.registerBrokerAll(false, true);
        }
    }

    public void updateTopicConfig(TopicConfig topicConfig) {
        TopicConfig old = this.topicConfigTable.put(topicConfig.getTopicName(), topicConfig);
        if (old != null) {
            log.info("update topic config, old: " + old + " new: " + topicConfig);
        } else {
            log.info("create new topic, " + topicConfig);
        }
        this.dataVersion.nextVersion();
        this.persist();
    }

    public void updateOrderTopicConfig(KVTable orderKVTableFromNs) {
        if (orderKVTableFromNs != null && orderKVTableFromNs.getTable() != null) {
            TopicConfig topicConfig;
            boolean isChange = false;
            Set orderTopics = orderKVTableFromNs.getTable().keySet();
            for (String topic : orderTopics) {
                topicConfig = this.topicConfigTable.get(topic);
                if (topicConfig == null || topicConfig.isOrder()) continue;
                topicConfig.setOrder(true);
                isChange = true;
                log.info("update order topic config, topic={}, order={}", (Object)topic, (Object)true);
            }
            for (String topic : this.topicConfigTable.keySet()) {
                if (orderTopics.contains(topic) || !(topicConfig = this.topicConfigTable.get(topic)).isOrder()) continue;
                topicConfig.setOrder(false);
                isChange = true;
                log.info("update order topic config, topic={}, order={}", (Object)topic, (Object)false);
            }
            if (isChange) {
                this.dataVersion.nextVersion();
                this.persist();
            }
        }
    }

    public boolean isOrderTopic(String topic) {
        TopicConfig topicConfig = this.topicConfigTable.get(topic);
        if (topicConfig == null) {
            return false;
        }
        return topicConfig.isOrder();
    }

    public void deleteTopicConfig(String topic) {
        TopicConfig old = this.topicConfigTable.remove(topic);
        if (old != null) {
            log.info("delete topic config OK, topic: " + old);
            this.dataVersion.nextVersion();
            this.persist();
        } else {
            log.warn("delete topic config failed, topic: " + topic + " not exist");
        }
    }

    public TopicConfigSerializeWrapper buildTopicConfigSerializeWrapper() {
        TopicConfigSerializeWrapper topicConfigSerializeWrapper = new TopicConfigSerializeWrapper();
        topicConfigSerializeWrapper.setTopicConfigTable(this.topicConfigTable);
        topicConfigSerializeWrapper.setDataVersion(this.dataVersion);
        return topicConfigSerializeWrapper;
    }

    public String encode() {
        return this.encode(false);
    }

    public String encode(boolean prettyFormat) {
        TopicConfigSerializeWrapper topicConfigSerializeWrapper = new TopicConfigSerializeWrapper();
        topicConfigSerializeWrapper.setTopicConfigTable(this.topicConfigTable);
        topicConfigSerializeWrapper.setDataVersion(this.dataVersion);
        return topicConfigSerializeWrapper.toJson(prettyFormat);
    }

    public void decode(String jsonString) {
        TopicConfigSerializeWrapper topicConfigSerializeWrapper;
        if (jsonString != null && (topicConfigSerializeWrapper = (TopicConfigSerializeWrapper)TopicConfigSerializeWrapper.fromJson((String)jsonString, TopicConfigSerializeWrapper.class)) != null) {
            this.topicConfigTable.putAll(topicConfigSerializeWrapper.getTopicConfigTable());
            this.dataVersion.assignNewOne(topicConfigSerializeWrapper.getDataVersion());
            this.printLoadDataWhenFirstBoot(topicConfigSerializeWrapper);
        }
    }

    private void printLoadDataWhenFirstBoot(TopicConfigSerializeWrapper tcs) {
        for (Map.Entry next : tcs.getTopicConfigTable().entrySet()) {
            log.info("load exist local topic, {}", (Object)((TopicConfig)next.getValue()).toString());
        }
    }

    public String configFilePath() {
        return BrokerPathConfigHelper.getTopicConfigPath(this.brokerController.getMessageStoreConfig().getStorePathRootDir());
    }

    public DataVersion getDataVersion() {
        return this.dataVersion;
    }

    public ConcurrentHashMap<String, TopicConfig> getTopicConfigTable() {
        return this.topicConfigTable;
    }
}

