/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.broker.processor;

import com.alibaba.rocketmq.broker.BrokerController;
import com.alibaba.rocketmq.broker.pagecache.OneMessageTransfer;
import com.alibaba.rocketmq.broker.pagecache.QueryMessageTransfer;
import com.alibaba.rocketmq.common.protocol.header.QueryMessageRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.QueryMessageResponseHeader;
import com.alibaba.rocketmq.common.protocol.header.ViewMessageRequestHeader;
import com.alibaba.rocketmq.remoting.exception.RemotingCommandException;
import com.alibaba.rocketmq.remoting.netty.NettyRequestProcessor;
import com.alibaba.rocketmq.remoting.protocol.RemotingCommand;
import com.alibaba.rocketmq.store.QueryMessageResult;
import com.alibaba.rocketmq.store.SelectMapedBufferResult;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryMessageProcessor
implements NettyRequestProcessor {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqBroker");
    private final BrokerController brokerController;

    public QueryMessageProcessor(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        switch (request.getCode()) {
            case 12: {
                return this.queryMessage(ctx, request);
            }
            case 33: {
                return this.viewMessageById(ctx, request);
            }
        }
        return null;
    }

    public RemotingCommand queryMessage(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(QueryMessageResponseHeader.class);
        QueryMessageResponseHeader responseHeader = (QueryMessageResponseHeader)response.readCustomHeader();
        QueryMessageRequestHeader requestHeader = (QueryMessageRequestHeader)request.decodeCommandCustomHeader(QueryMessageRequestHeader.class);
        response.setOpaque(request.getOpaque());
        final QueryMessageResult queryMessageResult = this.brokerController.getMessageStore().queryMessage(requestHeader.getTopic(), requestHeader.getKey(), requestHeader.getMaxNum().intValue(), requestHeader.getBeginTimestamp().longValue(), requestHeader.getEndTimestamp().longValue());
        assert (queryMessageResult != null);
        responseHeader.setIndexLastUpdatePhyoffset(Long.valueOf(queryMessageResult.getIndexLastUpdatePhyoffset()));
        responseHeader.setIndexLastUpdateTimestamp(Long.valueOf(queryMessageResult.getIndexLastUpdateTimestamp()));
        if (queryMessageResult.getBufferTotalSize() > 0) {
            response.setCode(0);
            response.setRemark(null);
            try {
                QueryMessageTransfer fileRegion = new QueryMessageTransfer(response.encodeHeader(queryMessageResult.getBufferTotalSize()), queryMessageResult);
                ctx.channel().writeAndFlush((Object)fileRegion).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        queryMessageResult.release();
                        if (!future.isSuccess()) {
                            log.error("transfer query message by pagecache failed, ", future.cause());
                        }
                    }
                });
            }
            catch (Throwable e) {
                log.error("", e);
                queryMessageResult.release();
            }
            return null;
        }
        response.setCode(22);
        response.setRemark("can not find message, maybe time range not correct");
        return response;
    }

    public RemotingCommand viewMessageById(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        ViewMessageRequestHeader requestHeader = (ViewMessageRequestHeader)request.decodeCommandCustomHeader(ViewMessageRequestHeader.class);
        response.setOpaque(request.getOpaque());
        final SelectMapedBufferResult selectMapedBufferResult = this.brokerController.getMessageStore().selectOneMessageByOffset(requestHeader.getOffset().longValue());
        if (selectMapedBufferResult != null) {
            response.setCode(0);
            response.setRemark(null);
            try {
                OneMessageTransfer fileRegion = new OneMessageTransfer(response.encodeHeader(selectMapedBufferResult.getSize()), selectMapedBufferResult);
                ctx.channel().writeAndFlush((Object)fileRegion).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        selectMapedBufferResult.release();
                        if (!future.isSuccess()) {
                            log.error("transfer one message by pagecache failed, ", future.cause());
                        }
                    }
                });
            }
            catch (Throwable e) {
                log.error("", e);
                selectMapedBufferResult.release();
            }
            return null;
        }
        response.setCode(1);
        response.setRemark("can not find message by the offset, " + requestHeader.getOffset());
        return response;
    }
}

