/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.broker.processor;

import com.alibaba.rocketmq.broker.BrokerController;
import com.alibaba.rocketmq.common.TopicFilterType;
import com.alibaba.rocketmq.common.message.Message;
import com.alibaba.rocketmq.common.message.MessageAccessor;
import com.alibaba.rocketmq.common.message.MessageDecoder;
import com.alibaba.rocketmq.common.message.MessageExt;
import com.alibaba.rocketmq.common.protocol.header.EndTransactionRequestHeader;
import com.alibaba.rocketmq.common.sysflag.MessageSysFlag;
import com.alibaba.rocketmq.remoting.common.RemotingHelper;
import com.alibaba.rocketmq.remoting.exception.RemotingCommandException;
import com.alibaba.rocketmq.remoting.netty.NettyRequestProcessor;
import com.alibaba.rocketmq.remoting.protocol.RemotingCommand;
import com.alibaba.rocketmq.store.MessageExtBrokerInner;
import com.alibaba.rocketmq.store.MessageStore;
import com.alibaba.rocketmq.store.PutMessageResult;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndTransactionProcessor
implements NettyRequestProcessor {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqBroker");
    private final BrokerController brokerController;
    private static final Logger logTransaction = LoggerFactory.getLogger((String)"RocketmqTransaction");

    public EndTransactionProcessor(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    private MessageExtBrokerInner endMessageTransaction(MessageExt msgExt) {
        MessageExtBrokerInner msgInner = new MessageExtBrokerInner();
        msgInner.setBody(msgExt.getBody());
        msgInner.setFlag(msgExt.getFlag());
        MessageAccessor.setProperties((Message)msgInner, (Map)msgExt.getProperties());
        TopicFilterType topicFilterType = (msgInner.getSysFlag() & 2) == 2 ? TopicFilterType.MULTI_TAG : TopicFilterType.SINGLE_TAG;
        long tagsCodeValue = MessageExtBrokerInner.tagsString2tagsCode((TopicFilterType)topicFilterType, (String)msgInner.getTags());
        msgInner.setTagsCode(tagsCodeValue);
        msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgExt.getProperties()));
        msgInner.setSysFlag(msgExt.getSysFlag());
        msgInner.setBornTimestamp(msgExt.getBornTimestamp());
        msgInner.setBornHost(msgExt.getBornHost());
        msgInner.setStoreHost(msgExt.getStoreHost());
        msgInner.setReconsumeTimes(msgExt.getReconsumeTimes());
        msgInner.setWaitStoreMsgOK(false);
        MessageAccessor.clearProperty((Message)msgInner, (String)"DELAY");
        msgInner.setTopic(msgExt.getTopic());
        msgInner.setQueueId(msgExt.getQueueId());
        return msgInner;
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        EndTransactionRequestHeader requestHeader;
        RemotingCommand response;
        block25: {
            block24: {
                response = RemotingCommand.createResponseCommand(null);
                requestHeader = (EndTransactionRequestHeader)request.decodeCommandCustomHeader(EndTransactionRequestHeader.class);
                if (!requestHeader.getFromTransactionCheck().booleanValue()) break block24;
                switch (requestHeader.getCommitOrRollback()) {
                    case 0: {
                        logTransaction.warn("check producer[{}] transaction state, but it's pending status.\nRequestHeader: {} Remark: {}", new Object[]{RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), requestHeader.toString(), request.getRemark()});
                        return null;
                    }
                    case 8: {
                        logTransaction.warn("check producer[{}] transaction state, the producer commit the message.\nRequestHeader: {} Remark: {}", new Object[]{RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), requestHeader.toString(), request.getRemark()});
                        break block25;
                    }
                    case 12: {
                        logTransaction.warn("check producer[{}] transaction state, the producer rollback the message.\nRequestHeader: {} Remark: {}", new Object[]{RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), requestHeader.toString(), request.getRemark()});
                        break block25;
                    }
                    default: {
                        return null;
                    }
                }
            }
            switch (requestHeader.getCommitOrRollback()) {
                case 0: {
                    logTransaction.warn("the producer[{}] end transaction in sending message,  and it's pending status.\nRequestHeader: {} Remark: {}", new Object[]{RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), requestHeader.toString(), request.getRemark()});
                    return null;
                }
                case 8: {
                    break;
                }
                case 12: {
                    logTransaction.warn("the producer[{}] end transaction in sending message, rollback the message.\nRequestHeader: {} Remark: {}", new Object[]{RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), requestHeader.toString(), request.getRemark()});
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        MessageExt msgExt = this.brokerController.getMessageStore().lookMessageByOffset(requestHeader.getCommitLogOffset().longValue());
        if (msgExt != null) {
            MessageStore messageStore;
            PutMessageResult putMessageResult;
            String pgroupRead = msgExt.getProperty("PGROUP");
            if (!pgroupRead.equals(requestHeader.getProducerGroup())) {
                response.setCode(1);
                response.setRemark("the producer group wrong");
                return response;
            }
            if (msgExt.getQueueOffset() != requestHeader.getTranStateTableOffset().longValue()) {
                response.setCode(1);
                response.setRemark("the transaction state table offset wrong");
                return response;
            }
            if (msgExt.getCommitLogOffset() != requestHeader.getCommitLogOffset().longValue()) {
                response.setCode(1);
                response.setRemark("the commit log offset wrong");
                return response;
            }
            MessageExtBrokerInner msgInner = this.endMessageTransaction(msgExt);
            msgInner.setSysFlag(MessageSysFlag.resetTransactionValue((int)msgInner.getSysFlag(), (int)requestHeader.getCommitOrRollback()));
            msgInner.setQueueOffset(requestHeader.getTranStateTableOffset().longValue());
            msgInner.setPreparedTransactionOffset(requestHeader.getCommitLogOffset().longValue());
            msgInner.setStoreTimestamp(msgExt.getStoreTimestamp());
            if (12 == requestHeader.getCommitOrRollback()) {
                msgInner.setBody(null);
            }
            if ((putMessageResult = (messageStore = this.brokerController.getMessageStore()).putMessage(msgInner)) != null) {
                switch (putMessageResult.getPutMessageStatus()) {
                    case PUT_OK: 
                    case FLUSH_DISK_TIMEOUT: 
                    case FLUSH_SLAVE_TIMEOUT: 
                    case SLAVE_NOT_AVAILABLE: {
                        response.setCode(0);
                        response.setRemark(null);
                        break;
                    }
                    case CREATE_MAPEDFILE_FAILED: {
                        response.setCode(1);
                        response.setRemark("create maped file failed.");
                        break;
                    }
                    case MESSAGE_ILLEGAL: {
                        response.setCode(13);
                        response.setRemark("the message is illegal, maybe length not matched.");
                        break;
                    }
                    case SERVICE_NOT_AVAILABLE: {
                        response.setCode(14);
                        response.setRemark("service not available now.");
                        break;
                    }
                    case UNKNOWN_ERROR: {
                        response.setCode(1);
                        response.setRemark("UNKNOWN_ERROR");
                        break;
                    }
                    default: {
                        response.setCode(1);
                        response.setRemark("UNKNOWN_ERROR DEFAULT");
                    }
                }
                return response;
            }
        } else {
            response.setCode(1);
            response.setRemark("find prepared transaction message failed");
            return response;
        }
        response.setCode(1);
        response.setRemark("store putMessage return null");
        return response;
    }
}

