/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.broker.processor;

import com.alibaba.rocketmq.broker.BrokerController;
import com.alibaba.rocketmq.broker.client.ClientChannelInfo;
import com.alibaba.rocketmq.broker.client.ConsumerGroupInfo;
import com.alibaba.rocketmq.broker.mqtrace.ConsumeMessageContext;
import com.alibaba.rocketmq.broker.mqtrace.ConsumeMessageHook;
import com.alibaba.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import com.alibaba.rocketmq.common.MixAll;
import com.alibaba.rocketmq.common.protocol.header.GetConsumerListByGroupRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.GetConsumerListByGroupResponseBody;
import com.alibaba.rocketmq.common.protocol.header.GetConsumerListByGroupResponseHeader;
import com.alibaba.rocketmq.common.protocol.header.QueryConsumerOffsetRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.QueryConsumerOffsetResponseHeader;
import com.alibaba.rocketmq.common.protocol.header.UnregisterClientRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.UnregisterClientResponseHeader;
import com.alibaba.rocketmq.common.protocol.header.UpdateConsumerOffsetRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.UpdateConsumerOffsetResponseHeader;
import com.alibaba.rocketmq.common.protocol.heartbeat.ConsumerData;
import com.alibaba.rocketmq.common.protocol.heartbeat.HeartbeatData;
import com.alibaba.rocketmq.common.subscription.SubscriptionGroupConfig;
import com.alibaba.rocketmq.common.sysflag.TopicSysFlag;
import com.alibaba.rocketmq.remoting.common.RemotingHelper;
import com.alibaba.rocketmq.remoting.exception.RemotingCommandException;
import com.alibaba.rocketmq.remoting.netty.NettyRequestProcessor;
import com.alibaba.rocketmq.remoting.protocol.RemotingCommand;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientManageProcessor
implements NettyRequestProcessor {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqBroker");
    private final BrokerController brokerController;
    private List<ConsumeMessageHook> consumeMessageHookList;

    public ClientManageProcessor(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        switch (request.getCode()) {
            case 34: {
                return this.heartBeat(ctx, request);
            }
            case 35: {
                return this.unregisterClient(ctx, request);
            }
            case 38: {
                return this.getConsumerListByGroup(ctx, request);
            }
            case 15: {
                return this.updateConsumerOffset(ctx, request);
            }
            case 14: {
                return this.queryConsumerOffset(ctx, request);
            }
        }
        return null;
    }

    public boolean hasConsumeMessageHook() {
        return this.consumeMessageHookList != null && !this.consumeMessageHookList.isEmpty();
    }

    public void registerConsumeMessageHook(List<ConsumeMessageHook> consumeMessageHookList) {
        this.consumeMessageHookList = consumeMessageHookList;
    }

    public void executeConsumeMessageHookAfter(ConsumeMessageContext context) {
        if (this.hasConsumeMessageHook()) {
            for (ConsumeMessageHook hook : this.consumeMessageHookList) {
                try {
                    hook.consumeMessageAfter(context);
                }
                catch (Throwable e) {}
            }
        }
    }

    private RemotingCommand updateConsumerOffset(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(UpdateConsumerOffsetResponseHeader.class);
        UpdateConsumerOffsetRequestHeader requestHeader = (UpdateConsumerOffsetRequestHeader)request.decodeCommandCustomHeader(UpdateConsumerOffsetRequestHeader.class);
        if (this.hasConsumeMessageHook()) {
            ConsumeMessageContext context = new ConsumeMessageContext();
            context.setConsumerGroup(requestHeader.getConsumerGroup());
            context.setTopic(requestHeader.getTopic());
            context.setClientHost(RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
            context.setSuccess(true);
            context.setStatus(ConsumeConcurrentlyStatus.CONSUME_SUCCESS.toString());
            InetSocketAddress storeHost = new InetSocketAddress(this.brokerController.getBrokerConfig().getBrokerIP1(), this.brokerController.getNettyServerConfig().getListenPort());
            long preOffset = this.brokerController.getConsumerOffsetManager().queryOffset(requestHeader.getConsumerGroup(), requestHeader.getTopic(), requestHeader.getQueueId());
            Map messageIds = this.brokerController.getMessageStore().getMessageIds(requestHeader.getTopic(), requestHeader.getQueueId().intValue(), preOffset, requestHeader.getCommitOffset().longValue(), (SocketAddress)storeHost);
            context.setMessageIds(messageIds);
            this.executeConsumeMessageHookAfter(context);
        }
        this.brokerController.getConsumerOffsetManager().commitOffset(requestHeader.getConsumerGroup(), requestHeader.getTopic(), requestHeader.getQueueId(), requestHeader.getCommitOffset());
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand queryConsumerOffset(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(QueryConsumerOffsetResponseHeader.class);
        QueryConsumerOffsetResponseHeader responseHeader = (QueryConsumerOffsetResponseHeader)response.readCustomHeader();
        QueryConsumerOffsetRequestHeader requestHeader = (QueryConsumerOffsetRequestHeader)request.decodeCommandCustomHeader(QueryConsumerOffsetRequestHeader.class);
        long offset = this.brokerController.getConsumerOffsetManager().queryOffset(requestHeader.getConsumerGroup(), requestHeader.getTopic(), requestHeader.getQueueId());
        if (offset >= 0L) {
            responseHeader.setOffset(Long.valueOf(offset));
            response.setCode(0);
            response.setRemark(null);
        } else {
            long minOffset = this.brokerController.getMessageStore().getMinOffsetInQuque(requestHeader.getTopic(), requestHeader.getQueueId().intValue());
            if (minOffset <= 0L && !this.brokerController.getMessageStore().checkInDiskByConsumeOffset(requestHeader.getTopic(), requestHeader.getQueueId().intValue(), 0L)) {
                responseHeader.setOffset(Long.valueOf(0L));
                response.setCode(0);
                response.setRemark(null);
            } else {
                response.setCode(22);
                response.setRemark("Not found, V3_0_6_SNAPSHOT maybe this group consumer boot first");
            }
        }
        return response;
    }

    public RemotingCommand getConsumerListByGroup(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(GetConsumerListByGroupResponseHeader.class);
        GetConsumerListByGroupRequestHeader requestHeader = (GetConsumerListByGroupRequestHeader)request.decodeCommandCustomHeader(GetConsumerListByGroupRequestHeader.class);
        ConsumerGroupInfo consumerGroupInfo = this.brokerController.getConsumerManager().getConsumerGroupInfo(requestHeader.getConsumerGroup());
        if (consumerGroupInfo != null) {
            List<String> clientIds = consumerGroupInfo.getAllClientId();
            if (!clientIds.isEmpty()) {
                GetConsumerListByGroupResponseBody body = new GetConsumerListByGroupResponseBody();
                body.setConsumerIdList(clientIds);
                response.setBody(body.encode());
                response.setCode(0);
                response.setRemark(null);
                return response;
            }
            log.warn("getAllClientId failed, {} {}", (Object)requestHeader.getConsumerGroup(), (Object)RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
        } else {
            log.warn("getConsumerGroupInfo failed, {} {}", (Object)requestHeader.getConsumerGroup(), (Object)RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
        }
        response.setCode(1);
        response.setRemark("no consumer for this group, " + requestHeader.getConsumerGroup());
        return response;
    }

    public RemotingCommand unregisterClient(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(UnregisterClientResponseHeader.class);
        UnregisterClientRequestHeader requestHeader = (UnregisterClientRequestHeader)request.decodeCommandCustomHeader(UnregisterClientRequestHeader.class);
        ClientChannelInfo clientChannelInfo = new ClientChannelInfo(ctx.channel(), requestHeader.getClientID(), request.getLanguage(), request.getVersion());
        String group = requestHeader.getProducerGroup();
        if (group != null) {
            this.brokerController.getProducerManager().unregisterProducer(group, clientChannelInfo);
        }
        if ((group = requestHeader.getConsumerGroup()) != null) {
            this.brokerController.getConsumerManager().unregisterConsumer(group, clientChannelInfo);
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    public RemotingCommand heartBeat(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        HeartbeatData heartbeatData = (HeartbeatData)HeartbeatData.decode((byte[])request.getBody(), HeartbeatData.class);
        ClientChannelInfo clientChannelInfo = new ClientChannelInfo(ctx.channel(), heartbeatData.getClientID(), request.getLanguage(), request.getVersion());
        for (ConsumerData data : heartbeatData.getConsumerDataSet()) {
            boolean changed;
            SubscriptionGroupConfig subscriptionGroupConfig = this.brokerController.getSubscriptionGroupManager().findSubscriptionGroupConfig(data.getGroupName());
            if (null != subscriptionGroupConfig) {
                int topicSysFlag = 0;
                if (data.isUnitMode()) {
                    topicSysFlag = TopicSysFlag.buildSysFlag((boolean)false, (boolean)true);
                }
                String newTopic = MixAll.getRetryTopic((String)data.getGroupName());
                this.brokerController.getTopicConfigManager().createTopicInSendMessageBackMethod(newTopic, subscriptionGroupConfig.getRetryQueueNums(), 6, topicSysFlag);
            }
            if (!(changed = this.brokerController.getConsumerManager().registerConsumer(data.getGroupName(), clientChannelInfo, data.getConsumeType(), data.getMessageModel(), data.getConsumeFromWhere(), data.getSubscriptionDataSet()))) continue;
            log.info("registerConsumer info changed {} {}", (Object)data.toString(), (Object)RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
        }
        for (ConsumerData data : heartbeatData.getProducerDataSet()) {
            this.brokerController.getProducerManager().registerProducer(data.getGroupName(), clientChannelInfo);
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }
}

