/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.broker.pagecache;

import com.alibaba.rocketmq.store.QueryMessageResult;
import io.netty.channel.FileRegion;
import io.netty.util.AbstractReferenceCounted;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.List;

public class QueryMessageTransfer
extends AbstractReferenceCounted
implements FileRegion {
    private final ByteBuffer byteBufferHeader;
    private final QueryMessageResult queryMessageResult;
    private long transfered;

    public QueryMessageTransfer(ByteBuffer byteBufferHeader, QueryMessageResult queryMessageResult) {
        this.byteBufferHeader = byteBufferHeader;
        this.queryMessageResult = queryMessageResult;
    }

    public long position() {
        int pos = this.byteBufferHeader.position();
        List messageBufferList = this.queryMessageResult.getMessageBufferList();
        for (ByteBuffer bb : messageBufferList) {
            pos += bb.position();
        }
        return pos;
    }

    public long count() {
        return this.byteBufferHeader.limit() + this.queryMessageResult.getBufferTotalSize();
    }

    public long transferTo(WritableByteChannel target, long position) throws IOException {
        if (this.byteBufferHeader.hasRemaining()) {
            this.transfered += (long)target.write(this.byteBufferHeader);
            return this.transfered;
        }
        List messageBufferList = this.queryMessageResult.getMessageBufferList();
        for (ByteBuffer bb : messageBufferList) {
            if (!bb.hasRemaining()) continue;
            this.transfered += (long)target.write(bb);
            return this.transfered;
        }
        return 0L;
    }

    public void close() {
        this.deallocate();
    }

    protected void deallocate() {
        this.queryMessageResult.release();
    }

    public long transfered() {
        return this.transfered;
    }
}

