/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.broker.pagecache;

import com.alibaba.rocketmq.store.SelectMapedBufferResult;
import io.netty.channel.FileRegion;
import io.netty.util.AbstractReferenceCounted;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class OneMessageTransfer
extends AbstractReferenceCounted
implements FileRegion {
    private final ByteBuffer byteBufferHeader;
    private final SelectMapedBufferResult selectMapedBufferResult;
    private long transfered;

    public OneMessageTransfer(ByteBuffer byteBufferHeader, SelectMapedBufferResult selectMapedBufferResult) {
        this.byteBufferHeader = byteBufferHeader;
        this.selectMapedBufferResult = selectMapedBufferResult;
    }

    public long position() {
        return this.byteBufferHeader.position() + this.selectMapedBufferResult.getByteBuffer().position();
    }

    public long count() {
        return this.byteBufferHeader.limit() + this.selectMapedBufferResult.getSize();
    }

    public long transferTo(WritableByteChannel target, long position) throws IOException {
        if (this.byteBufferHeader.hasRemaining()) {
            this.transfered += (long)target.write(this.byteBufferHeader);
            return this.transfered;
        }
        if (this.selectMapedBufferResult.getByteBuffer().hasRemaining()) {
            this.transfered += (long)target.write(this.selectMapedBufferResult.getByteBuffer());
            return this.transfered;
        }
        return 0L;
    }

    public void close() {
        this.deallocate();
    }

    protected void deallocate() {
        this.selectMapedBufferResult.release();
    }

    public long transfered() {
        return this.transfered;
    }
}

