/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.broker.out;

import com.alibaba.rocketmq.client.exception.MQBrokerException;
import com.alibaba.rocketmq.common.MixAll;
import com.alibaba.rocketmq.common.namesrv.RegisterBrokerResult;
import com.alibaba.rocketmq.common.namesrv.TopAddressing;
import com.alibaba.rocketmq.common.protocol.body.ConsumerOffsetSerializeWrapper;
import com.alibaba.rocketmq.common.protocol.body.KVTable;
import com.alibaba.rocketmq.common.protocol.body.RegisterBrokerBody;
import com.alibaba.rocketmq.common.protocol.body.SubscriptionGroupWrapper;
import com.alibaba.rocketmq.common.protocol.body.TopicConfigSerializeWrapper;
import com.alibaba.rocketmq.common.protocol.header.namesrv.RegisterBrokerRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.namesrv.RegisterBrokerResponseHeader;
import com.alibaba.rocketmq.common.protocol.header.namesrv.UnRegisterBrokerRequestHeader;
import com.alibaba.rocketmq.remoting.CommandCustomHeader;
import com.alibaba.rocketmq.remoting.RPCHook;
import com.alibaba.rocketmq.remoting.RemotingClient;
import com.alibaba.rocketmq.remoting.exception.RemotingCommandException;
import com.alibaba.rocketmq.remoting.exception.RemotingConnectException;
import com.alibaba.rocketmq.remoting.exception.RemotingSendRequestException;
import com.alibaba.rocketmq.remoting.exception.RemotingTimeoutException;
import com.alibaba.rocketmq.remoting.exception.RemotingTooMuchRequestException;
import com.alibaba.rocketmq.remoting.netty.NettyClientConfig;
import com.alibaba.rocketmq.remoting.netty.NettyRemotingClient;
import com.alibaba.rocketmq.remoting.protocol.RemotingCommand;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerOuterAPI {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqBroker");
    private final RemotingClient remotingClient;
    private final TopAddressing topAddressing = new TopAddressing(MixAll.WS_ADDR);
    private String nameSrvAddr = null;

    public BrokerOuterAPI(NettyClientConfig nettyClientConfig, RPCHook rpcHook) {
        this.remotingClient = new NettyRemotingClient(nettyClientConfig);
        this.remotingClient.registerRPCHook(rpcHook);
    }

    public BrokerOuterAPI(NettyClientConfig nettyClientConfig) {
        this(nettyClientConfig, null);
    }

    public void start() {
        this.remotingClient.start();
    }

    public void shutdown() {
        this.remotingClient.shutdown();
    }

    public String fetchNameServerAddr() {
        try {
            String addrs = this.topAddressing.fetchNSAddr();
            if (addrs != null && !addrs.equals(this.nameSrvAddr)) {
                log.info("name server address changed, old: " + this.nameSrvAddr + " new: " + addrs);
                this.updateNameServerAddressList(addrs);
                this.nameSrvAddr = addrs;
                return this.nameSrvAddr;
            }
        }
        catch (Exception e) {
            log.error("fetchNameServerAddr Exception", (Throwable)e);
        }
        return this.nameSrvAddr;
    }

    public void updateNameServerAddressList(String addrs) {
        ArrayList<String> lst = new ArrayList<String>();
        String[] addrArray = addrs.split(";");
        if (addrArray != null) {
            for (String addr : addrArray) {
                lst.add(addr);
            }
            this.remotingClient.updateNameServerAddressList(lst);
        }
    }

    private RegisterBrokerResult registerBroker(String namesrvAddr, String clusterName, String brokerAddr, String brokerName, long brokerId, String haServerAddr, TopicConfigSerializeWrapper topicConfigWrapper, List<String> filterServerList, boolean oneway) throws RemotingCommandException, MQBrokerException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException {
        RegisterBrokerRequestHeader requestHeader = new RegisterBrokerRequestHeader();
        requestHeader.setBrokerAddr(brokerAddr);
        requestHeader.setBrokerId(Long.valueOf(brokerId));
        requestHeader.setBrokerName(brokerName);
        requestHeader.setClusterName(clusterName);
        requestHeader.setHaServerAddr(haServerAddr);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)103, (CommandCustomHeader)requestHeader);
        RegisterBrokerBody requestBody = new RegisterBrokerBody();
        requestBody.setTopicConfigSerializeWrapper(topicConfigWrapper);
        requestBody.setFilterServerList(filterServerList);
        request.setBody(requestBody.encode());
        if (oneway) {
            try {
                this.remotingClient.invokeOneway(namesrvAddr, request, 3000L);
            }
            catch (RemotingTooMuchRequestException e) {
                // empty catch block
            }
            return null;
        }
        RemotingCommand response = this.remotingClient.invokeSync(namesrvAddr, request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                RegisterBrokerResponseHeader responseHeader = (RegisterBrokerResponseHeader)response.decodeCommandCustomHeader(RegisterBrokerResponseHeader.class);
                RegisterBrokerResult result = new RegisterBrokerResult();
                result.setMasterAddr(responseHeader.getMasterAddr());
                result.setHaServerAddr(responseHeader.getHaServerAddr());
                result.setHaServerAddr(responseHeader.getHaServerAddr());
                if (response.getBody() != null) {
                    result.setKvTable((KVTable)KVTable.decode((byte[])response.getBody(), KVTable.class));
                }
                return result;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public RegisterBrokerResult registerBrokerAll(String clusterName, String brokerAddr, String brokerName, long brokerId, String haServerAddr, TopicConfigSerializeWrapper topicConfigWrapper, List<String> filterServerList, boolean oneway) {
        RegisterBrokerResult registerBrokerResult = null;
        List nameServerAddressList = this.remotingClient.getNameServerAddressList();
        if (nameServerAddressList != null) {
            for (String namesrvAddr : nameServerAddressList) {
                try {
                    RegisterBrokerResult result = this.registerBroker(namesrvAddr, clusterName, brokerAddr, brokerName, brokerId, haServerAddr, topicConfigWrapper, filterServerList, oneway);
                    if (result != null) {
                        registerBrokerResult = result;
                    }
                    log.info("register broker to name server {} OK", (Object)namesrvAddr);
                }
                catch (Exception e) {
                    log.warn("registerBroker Exception, " + namesrvAddr, (Throwable)e);
                }
            }
        }
        return registerBrokerResult;
    }

    public void unregisterBroker(String namesrvAddr, String clusterName, String brokerAddr, String brokerName, long brokerId) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException {
        UnRegisterBrokerRequestHeader requestHeader = new UnRegisterBrokerRequestHeader();
        requestHeader.setBrokerAddr(brokerAddr);
        requestHeader.setBrokerId(Long.valueOf(brokerId));
        requestHeader.setBrokerName(brokerName);
        requestHeader.setClusterName(clusterName);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)104, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(namesrvAddr, request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public void unregisterBrokerAll(String clusterName, String brokerAddr, String brokerName, long brokerId) {
        List nameServerAddressList = this.remotingClient.getNameServerAddressList();
        if (nameServerAddressList != null) {
            for (String namesrvAddr : nameServerAddressList) {
                try {
                    this.unregisterBroker(namesrvAddr, clusterName, brokerAddr, brokerName, brokerId);
                    log.info("unregisterBroker OK, NamesrvAddr: {}", (Object)namesrvAddr);
                }
                catch (Exception e) {
                    log.warn("unregisterBroker Exception, " + namesrvAddr, (Throwable)e);
                }
            }
        }
    }

    public TopicConfigSerializeWrapper getAllTopicConfig(String addr) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)21, null);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return (TopicConfigSerializeWrapper)TopicConfigSerializeWrapper.decode((byte[])response.getBody(), TopicConfigSerializeWrapper.class);
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public ConsumerOffsetSerializeWrapper getAllConsumerOffset(String addr) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQBrokerException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)43, null);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return (ConsumerOffsetSerializeWrapper)ConsumerOffsetSerializeWrapper.decode((byte[])response.getBody(), ConsumerOffsetSerializeWrapper.class);
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public String getAllDelayOffset(String addr) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQBrokerException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)45, null);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return new String(response.getBody());
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public SubscriptionGroupWrapper getAllSubscriptionGroupConfig(String addr) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQBrokerException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)201, null);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return (SubscriptionGroupWrapper)SubscriptionGroupWrapper.decode((byte[])response.getBody(), SubscriptionGroupWrapper.class);
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public void registerRPCHook(RPCHook rpcHook) {
        this.remotingClient.registerRPCHook(rpcHook);
    }
}

