/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.broker.client.rebalance;

import com.alibaba.rocketmq.common.message.MessageQueue;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RebalanceLockManager {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqRebalanceLock");
    private static final long RebalanceLockMaxLiveTime = Long.parseLong(System.getProperty("rocketmq.broker.rebalance.lockMaxLiveTime", "60000"));
    private final Lock lock = new ReentrantLock();
    private final ConcurrentHashMap<String, ConcurrentHashMap<MessageQueue, LockEntry>> mqLockTable = new ConcurrentHashMap(1024);

    private boolean isLocked(String group, MessageQueue mq, String clientId) {
        LockEntry lockEntry;
        ConcurrentHashMap<MessageQueue, LockEntry> groupValue = this.mqLockTable.get(group);
        if (groupValue != null && (lockEntry = groupValue.get(mq)) != null) {
            boolean locked = lockEntry.isLocked(clientId);
            if (locked) {
                lockEntry.setLastUpdateTimestamp(System.currentTimeMillis());
            }
            return locked;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean tryLock(String group, MessageQueue mq, String clientId) {
        if (this.isLocked(group, mq, clientId)) return true;
        try {
            this.lock.lockInterruptibly();
            try {
                LockEntry lockEntry;
                ConcurrentHashMap<Object, LockEntry> groupValue = this.mqLockTable.get(group);
                if (null == groupValue) {
                    groupValue = new ConcurrentHashMap(32);
                    this.mqLockTable.put(group, groupValue);
                }
                if (null == (lockEntry = groupValue.get(mq))) {
                    lockEntry = new LockEntry();
                    lockEntry.setClientId(clientId);
                    groupValue.put(mq, lockEntry);
                    log.info("tryLock, message queue not locked, I got it. Group: {} NewClientId: {} {}", new Object[]{group, clientId, mq});
                }
                if (lockEntry.isLocked(clientId)) {
                    lockEntry.setLastUpdateTimestamp(System.currentTimeMillis());
                    boolean bl = true;
                    return bl;
                }
                String oldClientId = lockEntry.getClientId();
                if (lockEntry.isExpired()) {
                    lockEntry.setClientId(clientId);
                    lockEntry.setLastUpdateTimestamp(System.currentTimeMillis());
                    log.warn("tryLock, message queue lock expired, I got it. Group: {} OldClientId: {} NewClientId: {} {}", new Object[]{group, oldClientId, clientId, mq});
                    boolean bl = true;
                    return bl;
                }
                log.warn("tryLock, message queue locked by other client. Group: {} OtherClientId: {} NewClientId: {} {}", new Object[]{group, oldClientId, clientId, mq});
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (InterruptedException e) {
            log.error("putMessage exception", (Throwable)e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<MessageQueue> tryLockBatch(String group, Set<MessageQueue> mqs, String clientId) {
        HashSet<MessageQueue> lockedMqs = new HashSet<MessageQueue>(mqs.size());
        HashSet<MessageQueue> notLockedMqs = new HashSet<MessageQueue>(mqs.size());
        for (MessageQueue mq : mqs) {
            if (this.isLocked(group, mq, clientId)) {
                lockedMqs.add(mq);
                continue;
            }
            notLockedMqs.add(mq);
        }
        if (!notLockedMqs.isEmpty()) {
            try {
                this.lock.lockInterruptibly();
                try {
                    ConcurrentHashMap<Object, LockEntry> groupValue = this.mqLockTable.get(group);
                    if (null == groupValue) {
                        groupValue = new ConcurrentHashMap(32);
                        this.mqLockTable.put(group, groupValue);
                    }
                    for (MessageQueue mq : notLockedMqs) {
                        LockEntry lockEntry = groupValue.get(mq);
                        if (null == lockEntry) {
                            lockEntry = new LockEntry();
                            lockEntry.setClientId(clientId);
                            groupValue.put(mq, lockEntry);
                            log.info("tryLockBatch, message queue not locked, I got it. Group: {} NewClientId: {} {}", new Object[]{group, clientId, mq});
                        }
                        if (lockEntry.isLocked(clientId)) {
                            lockEntry.setLastUpdateTimestamp(System.currentTimeMillis());
                            lockedMqs.add(mq);
                            continue;
                        }
                        String oldClientId = lockEntry.getClientId();
                        if (lockEntry.isExpired()) {
                            lockEntry.setClientId(clientId);
                            lockEntry.setLastUpdateTimestamp(System.currentTimeMillis());
                            log.warn("tryLockBatch, message queue lock expired, I got it. Group: {} OldClientId: {} NewClientId: {} {}", new Object[]{group, oldClientId, clientId, mq});
                            lockedMqs.add(mq);
                            continue;
                        }
                        log.warn("tryLockBatch, message queue locked by other client. Group: {} OtherClientId: {} NewClientId: {} {}", new Object[]{group, oldClientId, clientId, mq});
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (InterruptedException e) {
                log.error("putMessage exception", (Throwable)e);
            }
        }
        return lockedMqs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockBatch(String group, Set<MessageQueue> mqs, String clientId) {
        try {
            this.lock.lockInterruptibly();
            try {
                ConcurrentHashMap<MessageQueue, LockEntry> groupValue = this.mqLockTable.get(group);
                if (null != groupValue) {
                    for (MessageQueue mq : mqs) {
                        LockEntry lockEntry = groupValue.get(mq);
                        if (null != lockEntry) {
                            if (lockEntry.getClientId().equals(clientId)) {
                                groupValue.remove(mq);
                                log.info("unlockBatch, Group: {} {} {}", new Object[]{group, mq, clientId});
                                continue;
                            }
                            log.warn("unlockBatch, but mq locked by other client: {}, Group: {} {} {}", new Object[]{lockEntry.getClientId(), group, mq, clientId});
                            continue;
                        }
                        log.warn("unlockBatch, but mq not locked, Group: {} {} {}", new Object[]{group, mq, clientId});
                    }
                } else {
                    log.warn("unlockBatch, group not exist, Group: {} {}", (Object)group, (Object)clientId);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (InterruptedException e) {
            log.error("putMessage exception", (Throwable)e);
        }
    }

    class LockEntry {
        private String clientId;
        private volatile long lastUpdateTimestamp = System.currentTimeMillis();

        LockEntry() {
        }

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public long getLastUpdateTimestamp() {
            return this.lastUpdateTimestamp;
        }

        public void setLastUpdateTimestamp(long lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
        }

        public boolean isExpired() {
            boolean expired = System.currentTimeMillis() - this.lastUpdateTimestamp > RebalanceLockMaxLiveTime;
            return expired;
        }

        public boolean isLocked(String clientId) {
            boolean eq = this.clientId.equals(clientId);
            return eq && !this.isExpired();
        }
    }
}

