/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.broker.client;

import com.alibaba.rocketmq.broker.client.ClientChannelInfo;
import com.alibaba.rocketmq.common.consumer.ConsumeFromWhere;
import com.alibaba.rocketmq.common.protocol.heartbeat.ConsumeType;
import com.alibaba.rocketmq.common.protocol.heartbeat.MessageModel;
import com.alibaba.rocketmq.common.protocol.heartbeat.SubscriptionData;
import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerGroupInfo {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqBroker");
    private final String groupName;
    private final ConcurrentHashMap<String, SubscriptionData> subscriptionTable = new ConcurrentHashMap();
    private final ConcurrentHashMap<Channel, ClientChannelInfo> channelInfoTable = new ConcurrentHashMap(16);
    private volatile ConsumeType consumeType;
    private volatile MessageModel messageModel;
    private volatile ConsumeFromWhere consumeFromWhere;
    private volatile long lastUpdateTimestamp = System.currentTimeMillis();

    public ConsumerGroupInfo(String groupName, ConsumeType consumeType, MessageModel messageModel, ConsumeFromWhere consumeFromWhere) {
        this.groupName = groupName;
        this.consumeType = consumeType;
        this.messageModel = messageModel;
        this.consumeFromWhere = consumeFromWhere;
    }

    public ClientChannelInfo findChannel(String clientId) {
        for (Map.Entry<Channel, ClientChannelInfo> next : this.channelInfoTable.entrySet()) {
            if (!next.getValue().getClientId().equals(clientId)) continue;
            return next.getValue();
        }
        return null;
    }

    public ConcurrentHashMap<String, SubscriptionData> getSubscriptionTable() {
        return this.subscriptionTable;
    }

    public ConcurrentHashMap<Channel, ClientChannelInfo> getChannelInfoTable() {
        return this.channelInfoTable;
    }

    public List<Channel> getAllChannel() {
        ArrayList<Channel> result = new ArrayList<Channel>();
        result.addAll(this.channelInfoTable.keySet());
        return result;
    }

    public List<String> getAllClientId() {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<Channel, ClientChannelInfo> entry : this.channelInfoTable.entrySet()) {
            ClientChannelInfo clientChannelInfo = entry.getValue();
            result.add(clientChannelInfo.getClientId());
        }
        return result;
    }

    public void unregisterChannel(ClientChannelInfo clientChannelInfo) {
        ClientChannelInfo old = this.channelInfoTable.remove(clientChannelInfo.getChannel());
        if (old != null) {
            log.info("unregister a consumer[{}] from consumerGroupInfo {}", (Object)this.groupName, (Object)old.toString());
        }
    }

    public boolean doChannelCloseEvent(String remoteAddr, Channel channel) {
        ClientChannelInfo info = this.channelInfoTable.remove(channel);
        if (info != null) {
            log.warn("NETTY EVENT: remove not active channel[{}] from ConsumerGroupInfo groupChannelTable, consumer group: {}", (Object)info.toString(), (Object)this.groupName);
            return true;
        }
        return false;
    }

    public boolean updateChannel(ClientChannelInfo infoNew, ConsumeType consumeType, MessageModel messageModel, ConsumeFromWhere consumeFromWhere) {
        boolean updated = false;
        this.consumeType = consumeType;
        this.messageModel = messageModel;
        this.consumeFromWhere = consumeFromWhere;
        ClientChannelInfo infoOld = this.channelInfoTable.get(infoNew.getChannel());
        if (null == infoOld) {
            ClientChannelInfo prev = this.channelInfoTable.put(infoNew.getChannel(), infoNew);
            if (null == prev) {
                log.info("new consumer connected, group: {} {} {} channel: {}", new Object[]{this.groupName, consumeType, messageModel, infoNew.toString()});
                updated = true;
            }
            infoOld = infoNew;
        } else if (!infoOld.getClientId().equals(infoNew.getClientId())) {
            log.error("[BUG] consumer channel exist in broker, but clientId not equal. GROUP: {} OLD: {} NEW: {} ", new Object[]{this.groupName, infoOld.toString(), infoNew.toString()});
            this.channelInfoTable.put(infoNew.getChannel(), infoNew);
        }
        this.lastUpdateTimestamp = System.currentTimeMillis();
        infoOld.setLastUpdateTimestamp(this.lastUpdateTimestamp);
        return updated;
    }

    public boolean updateSubscription(Set<SubscriptionData> subList) {
        boolean updated = false;
        for (SubscriptionData sub : subList) {
            SubscriptionData old = this.subscriptionTable.get(sub.getTopic());
            if (old == null) {
                SubscriptionData prev = this.subscriptionTable.put(sub.getTopic(), sub);
                if (null != prev) continue;
                updated = true;
                log.info("subscription changed, add new topic, group: {} {}", (Object)this.groupName, (Object)sub.toString());
                continue;
            }
            if (sub.getSubVersion() <= old.getSubVersion()) continue;
            if (this.consumeType == ConsumeType.CONSUME_PASSIVELY) {
                log.info("subscription changed, group: {} OLD: {} NEW: {}", new Object[]{this.groupName, old.toString(), sub.toString()});
            }
            this.subscriptionTable.put(sub.getTopic(), sub);
        }
        Iterator<Map.Entry<String, SubscriptionData>> it = this.subscriptionTable.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, SubscriptionData> next = it.next();
            String oldTopic = next.getKey();
            boolean exist = false;
            for (SubscriptionData sub : subList) {
                if (!sub.getTopic().equals(oldTopic)) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            log.warn("subscription changed, group: {} remove topic {} {}", new Object[]{this.groupName, oldTopic, next.getValue().toString()});
            it.remove();
            updated = true;
        }
        this.lastUpdateTimestamp = System.currentTimeMillis();
        return updated;
    }

    public Set<String> getSubscribeTopics() {
        return this.subscriptionTable.keySet();
    }

    public SubscriptionData findSubscriptionData(String topic) {
        return this.subscriptionTable.get(topic);
    }

    public ConsumeType getConsumeType() {
        return this.consumeType;
    }

    public void setConsumeType(ConsumeType consumeType) {
        this.consumeType = consumeType;
    }

    public MessageModel getMessageModel() {
        return this.messageModel;
    }

    public void setMessageModel(MessageModel messageModel) {
        this.messageModel = messageModel;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public long getLastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    public void setLastUpdateTimestamp(long lastUpdateTimestamp) {
        this.lastUpdateTimestamp = lastUpdateTimestamp;
    }

    public ConsumeFromWhere getConsumeFromWhere() {
        return this.consumeFromWhere;
    }

    public void setConsumeFromWhere(ConsumeFromWhere consumeFromWhere) {
        this.consumeFromWhere = consumeFromWhere;
    }
}

