/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.broker.client;

import com.alibaba.rocketmq.remoting.protocol.LanguageCode;
import io.netty.channel.Channel;

public class ClientChannelInfo {
    private final Channel channel;
    private final String clientId;
    private final LanguageCode language;
    private final int version;
    private volatile long lastUpdateTimestamp = System.currentTimeMillis();

    public ClientChannelInfo(Channel channel) {
        this(channel, null, null, 0);
    }

    public ClientChannelInfo(Channel channel, String clientId, LanguageCode language, int version) {
        this.channel = channel;
        this.clientId = clientId;
        this.language = language;
        this.version = version;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public String getClientId() {
        return this.clientId;
    }

    public LanguageCode getLanguage() {
        return this.language;
    }

    public int getVersion() {
        return this.version;
    }

    public long getLastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    public void setLastUpdateTimestamp(long lastUpdateTimestamp) {
        this.lastUpdateTimestamp = lastUpdateTimestamp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.channel == null ? 0 : this.channel.hashCode());
        result = 31 * result + (this.clientId == null ? 0 : this.clientId.hashCode());
        result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
        result = 31 * result + (int)(this.lastUpdateTimestamp ^ this.lastUpdateTimestamp >>> 32);
        result = 31 * result + this.version;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClientChannelInfo other = (ClientChannelInfo)obj;
        return !(this.channel == null ? other.channel != null : this.channel != other.channel);
    }

    public String toString() {
        return "ClientChannelInfo [channel=" + this.channel + ", clientId=" + this.clientId + ", language=" + this.language + ", version=" + this.version + ", lastUpdateTimestamp=" + this.lastUpdateTimestamp + "]";
    }
}

