/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayDeserializer
implements ObjectDeserializer {
    public static final ArrayDeserializer instance = new ArrayDeserializer();

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        Class<Object> componentClass;
        Type clazz;
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() == 8) {
            lexer.nextToken(16);
            return null;
        }
        if (lexer.token() == 4) {
            byte[] bytes = lexer.bytesValue();
            lexer.nextToken(16);
            return (T)bytes;
        }
        if (type instanceof GenericArrayType) {
            clazz = (GenericArrayType)type;
            Type componentType = clazz.getGenericComponentType();
            if (componentType instanceof TypeVariable) {
                TypeVariable typeVar = (TypeVariable)componentType;
                Type objType = parser.getContext().getType();
                if (objType instanceof ParameterizedType) {
                    ParameterizedType objParamType = (ParameterizedType)objType;
                    Type objRawType = objParamType.getRawType();
                    Type actualType = null;
                    if (objRawType instanceof Class) {
                        TypeVariable<Class<T>>[] objTypeParams = ((Class)objRawType).getTypeParameters();
                        for (int i = 0; i < objTypeParams.length; ++i) {
                            if (!objTypeParams[i].getName().equals(typeVar.getName())) continue;
                            actualType = objParamType.getActualTypeArguments()[i];
                        }
                    }
                    componentClass = actualType instanceof Class ? (Class<Object>)actualType : Object.class;
                } else {
                    componentClass = Object.class;
                }
            } else {
                componentClass = (Class<Object>)componentType;
            }
        } else {
            clazz = (Class)type;
            Class<Object> componentType = componentClass = ((Class)clazz).getComponentType();
        }
        JSONArray array = new JSONArray();
        parser.parseArray(componentClass, array, fieldName);
        return this.toObjectArray(parser, componentClass, array);
    }

    private <T> T toObjectArray(DefaultJSONParser parser, Class<?> componentType, JSONArray array) {
        if (array == null) {
            return null;
        }
        int size = array.size();
        Object objArray = Array.newInstance(componentType, size);
        for (int i = 0; i < size; ++i) {
            Object element;
            Object value = array.get(i);
            if (value == array) {
                Array.set(objArray, i, objArray);
                continue;
            }
            if (componentType.isArray()) {
                element = componentType.isInstance(value) ? value : this.toObjectArray(parser, componentType, (JSONArray)value);
                Array.set(objArray, i, element);
                continue;
            }
            element = null;
            if (value instanceof JSONArray) {
                boolean contains = false;
                JSONArray valueArray = (JSONArray)value;
                int valueArraySize = valueArray.size();
                for (int y = 0; y < valueArraySize; ++y) {
                    Object valueItem = valueArray.get(y);
                    if (valueItem != array) continue;
                    valueArray.set(i, objArray);
                    contains = true;
                }
                if (contains) {
                    element = valueArray.toArray();
                }
            }
            if (element == null) {
                element = TypeUtils.cast(value, componentType, parser.getConfig());
            }
            Array.set(objArray, i, element);
        }
        array.setRelatedArray(objArray);
        array.setComponentType(componentType);
        return (T)objArray;
    }

    @Override
    public int getFastMatchToken() {
        return 14;
    }
}

