/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.util.FnvHash;
import java.util.ArrayList;
import java.util.List;

public class SQLDataTypeImpl
extends SQLObjectImpl
implements SQLDataType {
    private String name;
    private long nameHashCode64;
    protected final List<SQLExpr> arguments = new ArrayList<SQLExpr>();
    private Boolean withTimeZone;
    private boolean withLocalTimeZone = false;
    private String dbType;
    private boolean unsigned;
    private boolean zerofill;

    public SQLDataTypeImpl() {
    }

    public SQLDataTypeImpl(String name) {
        this.name = name;
    }

    public SQLDataTypeImpl(String name, int precision) {
        this(name);
        this.addArgument(new SQLIntegerExpr(precision));
    }

    public SQLDataTypeImpl(String name, int precision, int scale) {
        this(name);
        this.addArgument(new SQLIntegerExpr(precision));
        this.addArgument(new SQLIntegerExpr(scale));
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.arguments);
        }
        visitor.endVisit(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long nameHashCode64() {
        if (this.nameHashCode64 == 0L) {
            this.nameHashCode64 = FnvHash.hashCode64(this.name);
        }
        return this.nameHashCode64;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.nameHashCode64 = 0L;
    }

    @Override
    public List<SQLExpr> getArguments() {
        return this.arguments;
    }

    public void addArgument(SQLExpr argument) {
        if (argument != null) {
            argument.setParent(this);
        }
        this.arguments.add(argument);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLDataTypeImpl dataType = (SQLDataTypeImpl)o;
        if (this.name != null ? !this.name.equals(dataType.name) : dataType.name != null) {
            return false;
        }
        if (this.arguments != null ? !this.arguments.equals(dataType.arguments) : dataType.arguments != null) {
            return false;
        }
        return this.withTimeZone != null ? this.withTimeZone.equals(dataType.withTimeZone) : dataType.withTimeZone == null;
    }

    public int hashCode() {
        long value = this.nameHashCode64();
        return (int)(value ^ value >>> 32);
    }

    @Override
    public Boolean getWithTimeZone() {
        return this.withTimeZone;
    }

    @Override
    public void setWithTimeZone(Boolean withTimeZone) {
        this.withTimeZone = withTimeZone;
    }

    @Override
    public boolean isWithLocalTimeZone() {
        return this.withLocalTimeZone;
    }

    @Override
    public void setWithLocalTimeZone(boolean withLocalTimeZone) {
        this.withLocalTimeZone = withLocalTimeZone;
    }

    @Override
    public String getDbType() {
        return this.dbType;
    }

    @Override
    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    @Override
    public SQLDataTypeImpl clone() {
        SQLDataTypeImpl x = new SQLDataTypeImpl();
        this.cloneTo(x);
        return x;
    }

    public void cloneTo(SQLDataTypeImpl x) {
        x.dbType = this.dbType;
        x.name = this.name;
        x.nameHashCode64 = this.nameHashCode64;
        for (SQLExpr arg : this.arguments) {
            x.addArgument(arg.clone());
        }
        x.withTimeZone = this.withTimeZone;
        x.withLocalTimeZone = this.withLocalTimeZone;
        x.zerofill = this.zerofill;
        x.unsigned = this.unsigned;
    }

    @Override
    public String toString() {
        return SQLUtils.toSQLString(this, this.dbType);
    }

    public boolean isUnsigned() {
        return this.unsigned;
    }

    public void setUnsigned(boolean unsigned) {
        this.unsigned = unsigned;
    }

    public boolean isZerofill() {
        return this.zerofill;
    }

    public void setZerofill(boolean zerofill) {
        this.zerofill = zerofill;
    }
}

