/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.teradata.parser;

import com.alibaba.druid.sql.parser.Keywords;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.NotAllowCommentException;
import com.alibaba.druid.sql.parser.Token;
import java.util.HashMap;

public class TeradataLexer
extends Lexer {
    public static final Keywords DEFAULT_TD_KEYWORDS;

    public TeradataLexer(String input) {
        super(input);
        this.keywods = DEFAULT_TD_KEYWORDS;
    }

    @Override
    public void scanComment() {
        if (this.ch != '/' && this.ch != '-') {
            throw new IllegalStateException();
        }
        this.mark = this.pos;
        this.bufPos = 0;
        this.scanChar();
        if (this.ch == '*') {
            this.scanChar();
            ++this.bufPos;
            while (this.ch == ' ') {
                this.scanChar();
                ++this.bufPos;
            }
            boolean isHint = false;
            int startHintSp = this.bufPos + 1;
            if (this.ch == '+') {
                isHint = true;
                this.scanChar();
                ++this.bufPos;
            }
            while (true) {
                if (this.ch == '*' && this.charAt(this.pos + 1) == '/') {
                    this.bufPos += 2;
                    break;
                }
                this.scanChar();
                ++this.bufPos;
            }
            this.scanChar();
            this.scanChar();
            if (isHint) {
                this.stringVal = this.subString(this.mark + startHintSp, this.bufPos - startHintSp - 1);
                this.token = Token.HINT;
            } else {
                this.stringVal = this.subString(this.mark, this.bufPos);
                this.token = Token.MULTI_LINE_COMMENT;
                if (this.keepComments) {
                    this.addComment(this.stringVal);
                }
            }
            if (this.token != Token.HINT && !this.isAllowComment()) {
                throw new NotAllowCommentException();
            }
            return;
        }
        if (!this.isAllowComment()) {
            throw new NotAllowCommentException();
        }
        if (this.ch == '/' || this.ch == '-') {
            this.scanChar();
            ++this.bufPos;
            while (true) {
                if (this.ch == '\r') {
                    if (this.charAt(this.pos + 1) == '\n') {
                        this.bufPos += 2;
                        this.scanChar();
                        break;
                    }
                    ++this.bufPos;
                    break;
                }
                if (this.ch == '\u001a') break;
                if (this.ch == '\n') {
                    this.scanChar();
                    ++this.bufPos;
                    break;
                }
                this.scanChar();
                ++this.bufPos;
            }
            this.stringVal = this.subString(this.mark + 1, this.bufPos);
            this.token = Token.LINE_COMMENT;
            if (this.keepComments) {
                this.addComment(this.stringVal);
            }
            this.endOfComment = this.isEOF();
            return;
        }
    }

    static {
        HashMap<String, Token> map = new HashMap<String, Token>();
        map.putAll(Keywords.DEFAULT_KEYWORDS.getKeywords());
        map.put("SEL", Token.SEL);
        map.put("LOCKING", Token.LOCKING);
        map.put("ACCESS", Token.ACCESS);
        map.put("RANGE_N", Token.RANGE_N);
        map.put("VOLATILE", Token.VOLATILE);
        map.put("MULTISET", Token.MULTISET);
        map.put("FORMAT", Token.FORMAT);
        map.put("QUALIFY", Token.QUALIFY);
        map.put("MOD", Token.MOD);
        DEFAULT_TD_KEYWORDS = new Keywords(map);
    }
}

