/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.mysql.parser;

import com.alibaba.druid.sql.parser.CharTypes;
import com.alibaba.druid.sql.parser.Keywords;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.NotAllowCommentException;
import com.alibaba.druid.sql.parser.SQLParseException;
import com.alibaba.druid.sql.parser.Token;
import java.util.HashMap;

public class MySqlLexer
extends Lexer {
    public static final Keywords DEFAULT_MYSQL_KEYWORDS;

    public MySqlLexer(char[] input, int inputLength, boolean skipComment) {
        super(input, inputLength, skipComment);
        this.keywods = DEFAULT_MYSQL_KEYWORDS;
    }

    public MySqlLexer(String input) {
        super(input);
        this.keywods = DEFAULT_MYSQL_KEYWORDS;
    }

    @Override
    public void scanVariable() {
        int first = this.ch;
        if (this.ch != '@' && this.ch != ':' && this.ch != '#' && this.ch != '$') {
            throw new SQLParseException("illegal variable");
        }
        int hash = first;
        this.np = this.bp;
        this.sp = 1;
        if (this.buf[this.bp + 1] == '@') {
            this.ch = this.buf[++this.bp];
            hash = 31 * hash + this.ch;
            ++this.sp;
        }
        if (this.buf[this.bp + 1] == '`') {
            char ch;
            ++this.bp;
            ++this.sp;
            while (true) {
                if ((ch = this.buf[++this.bp]) == '`') {
                    ++this.sp;
                    break;
                }
                if (ch == '\u001a') {
                    throw new SQLParseException("illegal identifier");
                }
                hash = 31 * hash + ch;
                ++this.sp;
            }
            ch = this.buf[++this.bp];
            this.ch = this.buf[this.bp];
            this.stringVal = this.symbolTable.addSymbol(this.buf, this.np, this.sp, hash);
            this.token = Token.VARIANT;
        } else if (this.buf[this.bp + 1] == '{') {
            char ch;
            ++this.bp;
            ++this.sp;
            while (true) {
                if ((ch = this.buf[++this.bp]) == '}') {
                    ++this.sp;
                    break;
                }
                if (ch == '\u001a') {
                    throw new SQLParseException("illegal identifier");
                }
                hash = 31 * hash + ch;
                ++this.sp;
            }
            ch = this.buf[++this.bp];
            this.ch = this.buf[this.bp];
            this.stringVal = this.symbolTable.addSymbol(this.buf, this.np, this.sp, hash);
            this.token = Token.VARIANT;
        } else {
            while (true) {
                this.ch = this.buf[++this.bp];
                if (!CharTypes.isIdentifierChar(this.ch)) break;
                hash = 31 * hash + this.ch;
                ++this.sp;
            }
        }
        this.ch = this.buf[this.bp];
        this.stringVal = this.symbolTable.addSymbol(this.buf, this.np, this.sp, hash);
        this.token = Token.VARIANT;
    }

    @Override
    public void scanIdentifier() {
        int first = this.ch;
        if (this.ch == '`') {
            char ch;
            int hash = first;
            this.np = this.bp;
            this.sp = 1;
            while (true) {
                if ((ch = this.buf[++this.bp]) == '`') {
                    ++this.sp;
                    break;
                }
                if (ch == '\u001a') {
                    throw new SQLParseException("illegal identifier");
                }
                hash = 31 * hash + ch;
                ++this.sp;
            }
            ch = this.buf[++this.bp];
            this.ch = this.buf[this.bp];
            this.stringVal = this.symbolTable.addSymbol(this.buf, this.np, this.sp, hash);
            Token tok = this.keywods.getKeyword(this.stringVal);
            this.token = tok != null ? tok : Token.IDENTIFIER;
        } else {
            char ch;
            boolean firstFlag = CharTypes.isFirstIdentifierChar((char)first);
            if (!firstFlag) {
                throw new SQLParseException("illegal identifier");
            }
            int hash = first;
            this.np = this.bp;
            this.sp = 1;
            while (CharTypes.isIdentifierChar(ch = this.buf[++this.bp])) {
                hash = 31 * hash + ch;
                ++this.sp;
            }
            this.ch = this.buf[this.bp];
            this.stringVal = this.symbolTable.addSymbol(this.buf, this.np, this.sp, hash);
            Token tok = this.keywods.getKeyword(this.stringVal);
            this.token = tok != null ? tok : Token.IDENTIFIER;
        }
    }

    @Override
    protected void scanString() {
        this.np = this.bp;
        boolean hasSpecial = false;
        while (true) {
            if (this.bp >= this.buflen) {
                this.lexError(this.tokenPos, "unclosed.str.lit", new Object[0]);
                return;
            }
            this.ch = this.buf[++this.bp];
            if (this.ch == '\\') {
                this.scanChar();
                if (!hasSpecial) {
                    System.arraycopy(this.buf, this.np + 1, this.sbuf, 0, this.sp);
                    hasSpecial = true;
                }
                switch (this.ch) {
                    case '\u0000': {
                        this.putChar('\u0000');
                        break;
                    }
                    case '\'': {
                        this.putChar('\'');
                        break;
                    }
                    case '\"': {
                        this.putChar('\"');
                        break;
                    }
                    case 'b': {
                        this.putChar('\b');
                        break;
                    }
                    case 'n': {
                        this.putChar('\n');
                        break;
                    }
                    case 'r': {
                        this.putChar('\r');
                        break;
                    }
                    case 't': {
                        this.putChar('\t');
                        break;
                    }
                    case '\\': {
                        this.putChar('\\');
                        break;
                    }
                    case 'Z': {
                        this.putChar('\u001a');
                        break;
                    }
                    default: {
                        this.putChar(this.ch);
                    }
                }
                this.scanChar();
            }
            if (this.ch == '\'') {
                this.scanChar();
                if (this.ch != '\'') break;
                System.arraycopy(this.buf, this.np + 1, this.sbuf, 0, this.sp);
                hasSpecial = true;
                this.putChar('\'');
                continue;
            }
            if (!hasSpecial) {
                ++this.sp;
                continue;
            }
            if (this.sp == this.sbuf.length) {
                this.putChar(this.ch);
                continue;
            }
            this.sbuf[this.sp++] = this.ch;
        }
        this.token = Token.LITERAL_CHARS;
        this.stringVal = !hasSpecial ? new String(this.buf, this.np + 1, this.sp) : new String(this.sbuf, 0, this.sp);
    }

    @Override
    public void scanComment() {
        if (this.ch != '/' && this.ch != '-') {
            throw new IllegalStateException();
        }
        this.np = this.bp;
        this.sp = 0;
        this.scanChar();
        if (this.ch == '*') {
            this.scanChar();
            ++this.sp;
            while (this.ch == ' ') {
                this.scanChar();
                ++this.sp;
            }
            boolean isHint = false;
            int startHintSp = this.sp + 1;
            if (this.ch == '!') {
                isHint = true;
                this.scanChar();
                ++this.sp;
            }
            while (true) {
                if (this.ch == '*' && this.buf[this.bp + 1] == '/') {
                    this.sp += 2;
                    break;
                }
                this.scanChar();
                ++this.sp;
            }
            this.scanChar();
            this.scanChar();
            if (isHint) {
                this.stringVal = new String(this.buf, this.np + startHintSp, this.sp - startHintSp - 1);
                this.token = Token.HINT;
            } else {
                this.stringVal = new String(this.buf, this.np, this.sp);
                this.token = Token.MULTI_LINE_COMMENT;
            }
            if (this.token != Token.HINT && !this.isAllowComment()) {
                throw new NotAllowCommentException();
            }
            return;
        }
        if (!this.isAllowComment()) {
            throw new NotAllowCommentException();
        }
        if (this.ch == '/' || this.ch == '-') {
            this.scanChar();
            ++this.sp;
            while (true) {
                if (this.ch == '\r') {
                    if (this.buf[this.bp + 1] == '\n') {
                        this.sp += 2;
                        this.scanChar();
                        break;
                    }
                    ++this.sp;
                    break;
                }
                if (this.ch == '\u001a') break;
                if (this.ch == '\n') {
                    this.scanChar();
                    ++this.sp;
                    break;
                }
                this.scanChar();
                ++this.sp;
            }
            this.stringVal = new String(this.buf, this.np + 1, this.sp);
            this.token = Token.LINE_COMMENT;
            return;
        }
    }

    static {
        HashMap<String, Token> map = new HashMap<String, Token>();
        map.putAll(Keywords.DEFAULT_KEYWORDS.getKeywords());
        map.put("DUAL", Token.DUAL);
        map.put("FALSE", Token.FALSE);
        map.put("IDENTIFIED", Token.IDENTIFIED);
        map.put("IF", Token.IF);
        map.put("KILL", Token.KILL);
        map.put("LIMIT", Token.LIMIT);
        map.put("TRUE", Token.TRUE);
        DEFAULT_MYSQL_KEYWORDS = new Keywords(map);
    }
}

