/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.proxy.jdbc;

import com.alibaba.druid.filter.FilterChain;
import com.alibaba.druid.filter.FilterChainImpl;
import com.alibaba.druid.proxy.jdbc.ConnectionProxy;
import com.alibaba.druid.proxy.jdbc.JdbcParameter;
import com.alibaba.druid.proxy.jdbc.StatementExecuteType;
import com.alibaba.druid.proxy.jdbc.StatementProxy;
import com.alibaba.druid.proxy.jdbc.WrapperProxyImpl;
import com.alibaba.druid.stat.JdbcSqlStat;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class StatementProxyImpl
extends WrapperProxyImpl
implements StatementProxy {
    private final ConnectionProxy connection;
    private final Statement statement;
    protected String lastExecuteSql;
    private long lastExecuteTimeNano;
    protected JdbcSqlStat sqlStat;
    protected boolean firstResultSet;
    protected ArrayList<String> batchSqlList;
    protected StatementExecuteType lastExecuteType;
    protected Integer updateCount = null;

    public StatementProxyImpl(ConnectionProxy connection, Statement statement, long id) {
        super(statement, id);
        this.connection = connection;
        this.statement = statement;
    }

    @Override
    public ConnectionProxy getConnectionProxy() {
        return this.connection;
    }

    @Override
    public Statement getRawObject() {
        return this.statement;
    }

    @Override
    public FilterChain createChain() {
        return new FilterChainImpl(this.connection.getDirectDataSource());
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (this.batchSqlList == null) {
            this.batchSqlList = new ArrayList();
        }
        this.createChain().statement_addBatch(this, sql);
        this.batchSqlList.add(sql);
    }

    @Override
    public void cancel() throws SQLException {
        this.createChain().statement_cancel(this);
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.batchSqlList == null) {
            this.batchSqlList = new ArrayList();
        }
        this.createChain().statement_clearBatch(this);
        this.batchSqlList.clear();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.createChain().statement_clearWarnings(this);
    }

    @Override
    public void close() throws SQLException {
        this.createChain().statement_close(this);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.updateCount = null;
        this.lastExecuteSql = sql;
        this.lastExecuteType = StatementExecuteType.Execute;
        this.firstResultSet = this.createChain().statement_execute(this, sql);
        return this.firstResultSet;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.updateCount = null;
        this.lastExecuteSql = sql;
        this.lastExecuteType = StatementExecuteType.Execute;
        this.firstResultSet = this.createChain().statement_execute((StatementProxy)this, sql, autoGeneratedKeys);
        return this.firstResultSet;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.updateCount = null;
        this.lastExecuteSql = sql;
        this.lastExecuteType = StatementExecuteType.Execute;
        this.firstResultSet = this.createChain().statement_execute((StatementProxy)this, sql, columnIndexes);
        return this.firstResultSet;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.updateCount = null;
        this.lastExecuteSql = sql;
        this.lastExecuteType = StatementExecuteType.Execute;
        this.firstResultSet = this.createChain().statement_execute((StatementProxy)this, sql, columnNames);
        return this.firstResultSet;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.firstResultSet = false;
        this.lastExecuteType = StatementExecuteType.ExecuteBatch;
        int[] updateCounts = this.createChain().statement_executeBatch(this);
        if (updateCounts != null && updateCounts.length == 1) {
            this.updateCount = updateCounts[0];
        }
        return updateCounts;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.firstResultSet = true;
        this.updateCount = null;
        this.lastExecuteSql = sql;
        this.lastExecuteType = StatementExecuteType.ExecuteQuery;
        return this.createChain().statement_executeQuery(this, sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.firstResultSet = false;
        this.lastExecuteSql = sql;
        this.lastExecuteType = StatementExecuteType.ExecuteUpdate;
        this.updateCount = this.createChain().statement_executeUpdate(this, sql);
        return this.updateCount;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.firstResultSet = false;
        this.lastExecuteSql = sql;
        this.lastExecuteType = StatementExecuteType.ExecuteUpdate;
        this.updateCount = this.createChain().statement_executeUpdate((StatementProxy)this, sql, autoGeneratedKeys);
        return this.updateCount;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.firstResultSet = false;
        this.lastExecuteSql = sql;
        this.lastExecuteType = StatementExecuteType.ExecuteUpdate;
        this.updateCount = this.createChain().statement_executeUpdate((StatementProxy)this, sql, columnIndexes);
        return this.updateCount;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.firstResultSet = false;
        this.lastExecuteSql = sql;
        this.lastExecuteType = StatementExecuteType.ExecuteUpdate;
        this.updateCount = this.createChain().statement_executeUpdate((StatementProxy)this, sql, columnNames);
        return this.updateCount;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.createChain().statement_getConnection(this);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.createChain().statement_getFetchDirection(this);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.createChain().statement_getFetchSize(this);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.createChain().statement_getGeneratedKeys(this);
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.createChain().statement_getMaxFieldSize(this);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.createChain().statement_getMaxRows(this);
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.updateCount = null;
        return this.createChain().statement_getMoreResults(this);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.updateCount = null;
        return this.createChain().statement_getMoreResults(this, current);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.createChain().statement_getQueryTimeout(this);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.createChain().statement_getResultSet(this);
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.createChain().statement_getResultSetConcurrency(this);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.createChain().statement_getResultSetHoldability(this);
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.createChain().statement_getResultSetType(this);
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.updateCount == null) {
            this.updateCount = this.createChain().statement_getUpdateCount(this);
        }
        return this.updateCount;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.createChain().statement_getWarnings(this);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.createChain().statement_isClosed(this);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.createChain().statement_isPoolable(this);
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.createChain().statement_setCursorName(this, name);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.createChain().statement_setEscapeProcessing(this, enable);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.createChain().statement_setFetchDirection(this, direction);
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.createChain().statement_setFetchSize(this, rows);
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.createChain().statement_setMaxFieldSize(this, max);
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.createChain().statement_setMaxRows(this, max);
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.createChain().statement_setPoolable(this, poolable);
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.createChain().statement_setQueryTimeout(this, seconds);
    }

    @Override
    public List<String> getBatchSqlList() {
        if (this.batchSqlList == null) {
            this.batchSqlList = new ArrayList();
        }
        return this.batchSqlList;
    }

    @Override
    public String getBatchSql() {
        List<String> sqlList = this.getBatchSqlList();
        StringBuffer buf = new StringBuffer();
        for (String item : sqlList) {
            if (buf.length() > 0) {
                buf.append("\n;\n");
            }
            buf.append(item);
        }
        return buf.toString();
    }

    @Override
    public String getLastExecuteSql() {
        return this.lastExecuteSql;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == Statement.class) {
            return (T)this.statement;
        }
        return super.unwrap(iface);
    }

    @Override
    public Map<Integer, JdbcParameter> getParameters() {
        return Collections.emptyMap();
    }

    @Override
    public JdbcSqlStat getSqlStat() {
        return this.sqlStat;
    }

    @Override
    public void setSqlStat(JdbcSqlStat sqlStat) {
        this.sqlStat = sqlStat;
    }

    @Override
    public long getLastExecuteTimeNano() {
        return this.lastExecuteTimeNano;
    }

    @Override
    public void setLastExecuteTimeNano(long lastExecuteTimeNano) {
        this.lastExecuteTimeNano = lastExecuteTimeNano;
    }

    @Override
    public StatementExecuteType getLastExecuteType() {
        return this.lastExecuteType;
    }

    @Override
    public boolean isFirstResultSet() {
        return this.firstResultSet;
    }
}

