/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.util;

import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;

public class StringUtils {
    private static final Log LOG = LogFactory.getLog(StringUtils.class);

    public static Integer subStringToInteger(String src, String start, String to) {
        return StringUtils.stringToInteger(StringUtils.subString(src, start, to));
    }

    public static String subString(String src, String start, String to) {
        int indexTo;
        int indexFrom = start == null ? 0 : src.indexOf(start);
        int n = indexTo = to == null ? src.length() : src.indexOf(to);
        if (indexFrom < 0 || indexTo < 0 || indexFrom > indexTo) {
            return null;
        }
        return src.substring(indexFrom += start.length(), indexTo);
    }

    public static Integer stringToInteger(String in) {
        if (in == null) {
            return null;
        }
        if ((in = in.trim()).length() == 0) {
            return null;
        }
        try {
            return Integer.parseInt(in);
        }
        catch (NumberFormatException e) {
            LOG.warn("stringToInteger fail,string=" + in, e);
            return null;
        }
    }

    public static boolean equals(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public static boolean equalsIgnoreCase(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equalsIgnoreCase(b);
    }

    public static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static int lowerHashCode(String text) {
        int h = 0;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch >= 'A' && ch <= 'Z') {
                ch = (char)(ch + 32);
            }
            h = 31 * h + ch;
        }
        return h;
    }
}

