/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool;

import com.alibaba.druid.pool.DruidDataSourceStatLogger;
import com.alibaba.druid.pool.DruidDataSourceStatValue;
import com.alibaba.druid.stat.JdbcSqlStatValue;
import com.alibaba.druid.support.json.JSONUtils;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.JdbcSqlStatUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class DruidDataSourceStatLoggerImpl
implements DruidDataSourceStatLogger {
    private static Log LOG = LogFactory.getLog(DruidDataSourceStatLoggerImpl.class);

    @Override
    public void log(DruidDataSourceStatValue statValue) {
        if (LOG.isInfoEnabled()) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("url", statValue.url);
            map.put("dbType", statValue.getDbType());
            map.put("name", statValue.getName());
            map.put("activeCount", statValue.getActiveCount());
            if (statValue.activePeak > 0) {
                map.put("activePeak", statValue.getActivePeak());
                map.put("activePeakTime", statValue.getActivePeakTime());
            }
            map.put("poolingCount", statValue.getPoolingCount());
            if (statValue.getPoolingPeak() > 0) {
                map.put("poolingPeak", statValue.getPoolingPeak());
                map.put("poolingPeakTime", statValue.getPoolingPeakTime());
            }
            map.put("connectCount", statValue.getConnectCount());
            map.put("closeCount", statValue.getCloseCount());
            if (statValue.getWaitThreadCount() > 0L) {
                map.put("waitThreadCount", statValue.getWaitThreadCount());
            }
            if (statValue.getNotEmptyWaitCount() > 0L) {
                map.put("notEmptyWaitCount", statValue.getNotEmptyWaitCount());
            }
            if (statValue.getNotEmptyWaitMillis() > 0L) {
                map.put("notEmptyWaitMillis", statValue.getNotEmptyWaitMillis());
            }
            if (statValue.getLogicConnectErrorCount() > 0L) {
                map.put("logicConnectErrorCount", statValue.getLogicConnectErrorCount());
            }
            if (statValue.getPhysicalConnectCount() > 0L) {
                map.put("physicalConnectCount", statValue.getPhysicalConnectCount());
            }
            if (statValue.getPhysicalCloseCount() > 0L) {
                map.put("physicalCloseCount", statValue.getPhysicalCloseCount());
            }
            if (statValue.getPhysicalConnectErrorCount() > 0L) {
                map.put("physicalConnectErrorCount", statValue.getPhysicalConnectErrorCount());
            }
            if (statValue.getExecuteCount() > 0L) {
                map.put("executeCount", statValue.getExecuteCount());
            }
            if (statValue.getErrorCount() > 0L) {
                map.put("errorCount", statValue.getErrorCount());
            }
            if (statValue.getCommitCount() > 0L) {
                map.put("commitCount", statValue.getCommitCount());
            }
            if (statValue.getRollbackCount() > 0L) {
                map.put("rollbackCount", statValue.getRollbackCount());
            }
            if (statValue.getPstmtCacheHitCount() > 0L) {
                map.put("pstmtCacheHitCount", statValue.getPstmtCacheHitCount());
            }
            if (statValue.getPstmtCacheMissCount() > 0L) {
                map.put("pstmtCacheMissCount", statValue.getPstmtCacheMissCount());
            }
            if (statValue.getStartTransactionCount() > 0L) {
                map.put("startTransactionCount", statValue.getStartTransactionCount());
                map.put("transactionHistogram", JdbcSqlStatUtils.rtrim(statValue.getTransactionHistogram()));
            }
            if (statValue.getConnectCount() > 0L) {
                map.put("connectionHoldTimeHistogram", JdbcSqlStatUtils.rtrim(statValue.getConnectionHoldTimeHistogram()));
            }
            if (statValue.getClobOpenCount() > 0L) {
                map.put("clobOpenCount", statValue.getClobOpenCount());
            }
            if (statValue.getBlobOpenCount() > 0L) {
                map.put("blobOpenCount", statValue.getBlobOpenCount());
            }
            if (statValue.getSqlSkipCount() > 0L) {
                map.put("sqlSkipCount", statValue.getSqlSkipCount());
            }
            ArrayList sqlList = new ArrayList();
            if (statValue.sqlList.size() > 0) {
                for (JdbcSqlStatValue sqlStat : statValue.getSqlList()) {
                    int concurrentMax;
                    int runningCount;
                    long executeErrorCount;
                    LinkedHashMap<String, Object> sqlStatMap = new LinkedHashMap<String, Object>();
                    sqlStatMap.put("sql", sqlStat.getSql());
                    if (sqlStat.getExecuteCount() > 0L) {
                        sqlStatMap.put("executeCount", sqlStat.getExecuteCount());
                        sqlStatMap.put("executeMillisMax", sqlStat.getExecuteMillisMax());
                        sqlStatMap.put("executeMillisTotal", sqlStat.getExecuteMillisTotal());
                        sqlStatMap.put("executeHistogram", JdbcSqlStatUtils.rtrim(sqlStat.getExecuteHistogram()));
                        sqlStatMap.put("executeAndResultHoldHistogram", JdbcSqlStatUtils.rtrim(sqlStat.getExecuteAndResultHoldHistogram()));
                    }
                    if ((executeErrorCount = sqlStat.getExecuteErrorCount()) > 0L) {
                        sqlStatMap.put("executeErrorCount", executeErrorCount);
                    }
                    if ((runningCount = sqlStat.getRunningCount()) > 0) {
                        sqlStatMap.put("runningCount", runningCount);
                    }
                    if ((concurrentMax = sqlStat.getConcurrentMax()) > 0) {
                        sqlStatMap.put("concurrentMax", concurrentMax);
                    }
                    if (sqlStat.getFetchRowCount() > 0L) {
                        sqlStatMap.put("fetchRowCount", sqlStat.getFetchRowCount());
                        sqlStatMap.put("fetchRowCount", sqlStat.getFetchRowCountMax());
                        sqlStatMap.put("fetchRowHistogram", JdbcSqlStatUtils.rtrim(sqlStat.getFetchRowHistogram()));
                    }
                    if (sqlStat.getUpdateCount() > 0L) {
                        sqlStatMap.put("updateCount", sqlStat.getUpdateCount());
                        sqlStatMap.put("updateCountMax", sqlStat.getUpdateCountMax());
                        sqlStatMap.put("updateHistogram", JdbcSqlStatUtils.rtrim(sqlStat.getUpdateHistogram()));
                    }
                    if (sqlStat.getInTransactionCount() > 0L) {
                        sqlStatMap.put("inTransactionCount", sqlStat.getInTransactionCount());
                    }
                    if (sqlStat.getClobOpenCount() > 0L) {
                        sqlStatMap.put("clobOpenCount", sqlStat.getClobOpenCount());
                    }
                    if (sqlStat.getBlobOpenCount() > 0L) {
                        sqlStatMap.put("blobOpenCount", sqlStat.getBlobOpenCount());
                    }
                    sqlList.add(sqlStatMap);
                }
                map.put("sqlList", sqlList);
            }
            String text = JSONUtils.toJSONString(map);
            LOG.info(text);
        }
    }
}

