/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.data.record;

import co.paralleluniverse.data.record.Record;
import co.paralleluniverse.data.record.RecordType;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;

final class SerializedRecord<R>
implements Serializable {
    public static final long serialVersionUID = 8978406234220L;
    private Record<R> r;

    public SerializedRecord(Record<R> r) {
        this.r = r;
    }

    public SerializedRecord() {
        this.r = null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.r.type().getName());
        out.writeInt(this.r.fields().size());
        this.r.write(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String typeName = in.readUTF();
        int numFields = in.readInt();
        RecordType<?> type = RecordType.forName(typeName);
        this.r = type.newInstance();
        this.r.read(in, numFields);
    }

    private Object readResolve() throws ObjectStreamException {
        return this.r;
    }
}

